<?php 

if ( ! isset( $content_width ) )
	$content_width = 900;

function howardsimple_setup() {
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-header', array(
		'width'         => 1460,
		'height'        => 360,
		'default-image' => get_template_directory_uri() . '/images/sunset_bw.jpg',
		'uploads'       => true,
		'header-text'   => false,
	) );

	register_nav_menus( array( 
		'primary' => __( 'Primary Navigation', 'howardsimple' )
	) );
}
add_action( 'after_setup_theme', 'howardsimple_setup' );

function howardsimple_enqueue_js() {
	if ( is_singular() )
		wp_enqueue_script( "comment-reply" );
}
add_action( 'wp_enqueue_scripts', 'howardsimple_enqueue_js' );

function howardsimple_register_sidebars() {
	register_sidebar( array(
		'name' => 'Main Sidebar',
		'id' => 'main-sidebar',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>'
	) );
}
add_action( 'widgets_init', 'howardsimple_register_sidebars' );

?>
