<?php
$banner_slider_query = new WP_Query( $banner_slider_args );
if ( $banner_slider_query->have_posts() ) {
	?>
	<div class="banner-slider-area">
		<div class="container-wrap banner-carousel">
			<?php
			while ( $banner_slider_query->have_posts() ) :
				$banner_slider_query->the_post();
				?>
				<div class="single-card-container tile-card">
					<div class="single-card-image">
						<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
					</div>
					<div class="single-card-detail">
						<div class="card-categories">
							<?php hourly_news_categories_list(); ?>
						</div>
						<h3 class="card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<div class="post-exerpt">
							<p><?php echo wp_kses_post( wp_trim_words( get_the_content(), 25 ) ); ?></p>
						</div>
						<div class="card-meta">
							<?php
								hourly_news_posted_by();
								hourly_news_posted_on();
							?>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>

	<?php
}
