<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'hourly_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'hourly_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'hourly-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'hourly_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'hourly-news' ),
		'section'  => 'hourly_news_single_page_options',
		'settings' => 'hourly_news_related_posts_title',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'hourly_news_related_posts_title',
		array(
			'selector'            => '.theme-wrapper h2.related-title',
			'settings'            => 'hourly_news_related_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}
