<?php
/**
 * Sidebar settings
 */

$wp_customize->add_section(
	'hourly_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Sidebar Option - Archive Sidebar Position.
$wp_customize->add_setting(
	'hourly_news_archive_sidebar_position',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'hourly_news_archive_sidebar_position',
	array(
		'label'   => esc_html__( 'Archive Sidebar Position', 'hourly-news' ),
		'section' => 'hourly_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'hourly-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'hourly-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'hourly_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'hourly_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'hourly-news' ),
		'section' => 'hourly_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'hourly-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'hourly-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'hourly_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'hourly_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'hourly-news' ),
		'section' => 'hourly_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'hourly-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'hourly-news' ),
		),
	)
);
