<?php

$wp_customize->add_section(
	'hourly_news_posts_meta_options',
	array(
		'title' => esc_html__( 'Post Meta Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Enable post category setting.
$wp_customize->add_setting(
	'hourly_news_enable_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_enable_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'hourly-news' ),
			'settings' => 'hourly_news_enable_category',
			'section'  => 'hourly_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post author setting.
$wp_customize->add_setting(
	'hourly_news_enable_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_enable_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'hourly-news' ),
			'settings' => 'hourly_news_enable_author',
			'section'  => 'hourly_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post date setting.
$wp_customize->add_setting(
	'hourly_news_enable_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_enable_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'hourly-news' ),
			'settings' => 'hourly_news_enable_date',
			'section'  => 'hourly_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable post tag setting.
$wp_customize->add_setting(
	'hourly_news_enable_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_enable_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'hourly-news' ),
			'settings' => 'hourly_news_enable_tag',
			'section'  => 'hourly_news_posts_meta_options',
			'type'     => 'checkbox',
		)
	)
);
