<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'hourly_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'hourly_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'hourly-news' ),
			'settings' => 'hourly_news_pagination_enable',
			'section'  => 'hourly_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'hourly_news_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'hourly-news' ),
		'section'         => 'hourly_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'hourly-news' ),
			'numeric' => __( 'Numeric', 'hourly-news' ),
		),
		'active_callback' => 'hourly_news_pagination_enabled',
	)
);

/*========================Active Callback==============================*/
function hourly_news_pagination_enabled( $control ) {
	return $control->manager->get_setting( 'hourly_news_pagination_enable' )->value();
}
