<?php
/**
 * Header Options
 */

// Header Options.
$wp_customize->add_section(
	'hourly_news_header_section',
	array(
		'title' => esc_html__( 'Header Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Enable Topbar Section.
$wp_customize->add_setting(
	'hourly_news_topbar_section_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_topbar_section_enable',
		array(
			'label'    => esc_html__( 'Enable Topbar Section.', 'hourly-news' ),
			'settings' => 'hourly_news_topbar_section_enable',
			'section'  => 'hourly_news_header_section',
			'type'     => 'checkbox',
		)
	)
);

// Header Advertisement Image.
$wp_customize->add_setting(
	'hourly_news_header_ads_img',
	array(
		'default'           => '',
		'sanitize_callback' => 'hourly_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'hourly_news_header_ads_img',
		array(
			'label'    => esc_html__( 'Advertisement', 'hourly-news' ),
			'section'  => 'hourly_news_header_section',
			'settings' => 'hourly_news_header_ads_img',
		)
	)
);

// Header Advertisement URL.
$wp_customize->add_setting(
	'hourly_news_header_ads_img_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'hourly_news_header_ads_img_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'hourly-news' ),
		'section'  => 'hourly_news_header_section',
		'settings' => 'hourly_news_header_ads_img_url',
		'type'     => 'url',
	)
);

// Header Button label setting.
$wp_customize->add_setting(
	'hourly_news_header_button_label',
	array(
		'default'           => __( 'Sign In', 'hourly-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'hourly_news_header_button_label',
	array(
		'label'    => esc_html__( 'Header Button Label', 'hourly-news' ),
		'section'  => 'hourly_news_header_section',
		'settings' => 'hourly_news_header_button_label',
		'type'     => 'text',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'hourly_news_header_button_label',
		array(
			'selector'            => '.header-button a',
			'settings'            => 'hourly_news_header_button_label',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Header Button URL setting.
$wp_customize->add_setting(
	'hourly_news_header_button_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'hourly_news_header_button_url',
	array(
		'label'    => esc_html__( 'Header Button Link', 'hourly-news' ),
		'section'  => 'hourly_news_header_section',
		'settings' => 'hourly_news_header_button_url',
		'type'     => 'url',
	)
);

/*========================Active Callback==============================*/
function hourly_news_if_topbar_section_enabled( $control ) {
	return $control->manager->get_setting( 'hourly_news_topbar_section_enable' )->value();
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'hourly_news_highlights_news_title_text_partial' ) ) :
	// Title.
	function hourly_news_highlights_news_title_text_partial() {
		return esc_html( get_theme_mod( 'hourly_news_highlights_news_title' ) );
	}
endif;