<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'hourly_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'hourly_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'hourly-news' ),
			'type'     => 'checkbox',
			'settings' => 'hourly_news_breadcrumb_enable',
			'section'  => 'hourly_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'hourly_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'hourly_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'hourly-news' ),
		'section'         => 'hourly_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'hourly_news_breadcrumb_enable' )->value() );
		},
	)
);
