<?php
/**
 * Blog / Archive Options
 */

$wp_customize->add_section(
	'hourly_news_archive_page_options',
	array(
		'title' => esc_html__( 'Blog / Archive Pages Options', 'hourly-news' ),
		'panel' => 'hourly_news_theme_options_panel',
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'hourly_news_excerpt_length',
	array(
		'default'           => 15,
		'sanitize_callback' => 'hourly_news_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'hourly_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'hourly-news' ),
		'section'     => 'hourly_news_archive_page_options',
		'settings'    => 'hourly_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 5,
			'max'  => 200,
			'step' => 1,
		),
	)
);

// Archive Column layout options.
$wp_customize->add_setting(
	'hourly_news_archive_column_layout',
	array(
		'default'           => 'double-column',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_archive_column_layout',
	array(
		'label'   => esc_html__( 'Column Layout', 'hourly-news' ),
		'section' => 'hourly_news_archive_page_options',
		'type'    => 'select',
		'choices' => array(
			'double-column' => __( 'Column 2', 'hourly-news' ),
			'triple-column' => __( 'Column 3', 'hourly-news' ),
		),
	)
);
