<?php
/**
 * Frontpage Customizer Settings
 *
 * @package Hourly News
 *
 * Recent Articles Section
 */

$wp_customize->add_section(
	'hourly_news_recent_articles_section',
	array(
		'title' => esc_html__( 'Recent Articles Section', 'hourly-news' ),
		'panel' => 'hourly_news_frontpage_panel',
	)
);

// Recent Articles section enable settings.
$wp_customize->add_setting(
	'hourly_news_recent_articles_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_recent_articles_section_enable',
		array(
			'label'    => esc_html__( 'Enable Recent Articles Section', 'hourly-news' ),
			'type'     => 'checkbox',
			'settings' => 'hourly_news_recent_articles_section_enable',
			'section'  => 'hourly_news_recent_articles_section',
		)
	)
);

// Recent Articles title settings.
$wp_customize->add_setting(
	'hourly_news_recent_articles_title',
	array(
		'default'           => __( 'Recent Articles', 'hourly-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'hourly_news_recent_articles_title',
	array(
		'label'           => esc_html__( 'Section Title', 'hourly-news' ),
		'section'         => 'hourly_news_recent_articles_section',
		'active_callback' => 'hourly_news_if_recent_articles_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'hourly_news_recent_articles_title',
		array(
			'selector'            => '.recent-articles h3.section-title',
			'settings'            => 'hourly_news_recent_articles_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Recent Articles Button Label settings.
$wp_customize->add_setting(
	'hourly_news_recent_articles_button_label',
	array(
		'default'           => __( 'View All', 'hourly-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'hourly_news_recent_articles_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'hourly-news' ),
		'section'         => 'hourly_news_recent_articles_section',
		'settings'        => 'hourly_news_recent_articles_button_label',
		'type'            => 'text',
		'active_callback' => 'hourly_news_if_recent_articles_enabled',
	)
);

// Recent Articles Button URL settings.
$wp_customize->add_setting(
	'hourly_news_recent_articles_button_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'hourly_news_recent_articles_button_url',
	array(
		'label'           => esc_html__( 'Button Link', 'hourly-news' ),
		'section'         => 'hourly_news_recent_articles_section',
		'settings'        => 'hourly_news_recent_articles_button_url',
		'type'            => 'url',
		'active_callback' => 'hourly_news_if_recent_articles_enabled',
	)
);

// recent_articles content type settings.
$wp_customize->add_setting(
	'hourly_news_recent_articles_content_type',
	array(
		'default'           => 'recent',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_recent_articles_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'hourly-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'hourly-news' ),
		'section'         => 'hourly_news_recent_articles_section',
		'type'            => 'select',
		'active_callback' => 'hourly_news_if_recent_articles_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'hourly-news' ),
			'category' => esc_html__( 'Category', 'hourly-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// recent_articles post setting.
	$wp_customize->add_setting(
		'hourly_news_recent_articles_post_' . $i,
		array(
			'sanitize_callback' => 'hourly_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'hourly_news_recent_articles_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'hourly-news' ), $i ),
			'section'         => 'hourly_news_recent_articles_section',
			'type'            => 'select',
			'choices'         => hourly_news_get_post_choices(),
			'active_callback' => 'hourly_news_recent_articles_section_content_type_post_enabled',
		)
	);

}

// recent_articles category setting.
$wp_customize->add_setting(
	'hourly_news_recent_articles_category',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_recent_articles_category',
	array(
		'label'           => esc_html__( 'Category', 'hourly-news' ),
		'section'         => 'hourly_news_recent_articles_section',
		'type'            => 'select',
		'choices'         => hourly_news_get_post_cat_choices(),
		'active_callback' => 'hourly_news_recent_articles_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function hourly_news_if_recent_articles_enabled( $control ) {
	return $control->manager->get_setting( 'hourly_news_recent_articles_section_enable' )->value();
}
function hourly_news_recent_articles_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_recent_articles_content_type' )->value();
	return hourly_news_if_recent_articles_enabled( $control ) && ( 'post' === $content_type );
}
function hourly_news_recent_articles_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_recent_articles_content_type' )->value();
	return hourly_news_if_recent_articles_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'hourly_news_recent_articles_title_text_partial' ) ) :
	// Title.
	function hourly_news_recent_articles_title_text_partial() {
		return esc_html( get_theme_mod( 'hourly_news_recent_articles_title' ) );
	}
endif;
