<?php
/**
 * Highlights Options
 */

// Highlights Options.
$wp_customize->add_section(
	'hourly_news_highlights_section',
	array(
		'title' => esc_html__( 'Highlights Section', 'hourly-news' ),
		'panel' => 'hourly_news_frontpage_panel',
	)
);


// Highlights News section enable settings.
$wp_customize->add_setting(
	'hourly_news_highlights_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_highlights_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Highlights News Section', 'hourly-news' ),
			'type'     => 'checkbox',
			'settings' => 'hourly_news_highlights_news_section_enable',
			'section'  => 'hourly_news_highlights_section',
		)
	)
);

// Highlights News title settings.
$wp_customize->add_setting(
	'hourly_news_highlights_news_title',
	array(
		'default'           => __( 'Highlights News', 'hourly-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'hourly_news_highlights_news_title',
	array(
		'label'           => esc_html__( 'Section Title', 'hourly-news' ),
		'section'         => 'hourly_news_highlights_section',
		'active_callback' => 'hourly_news_if_highlights_news_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'hourly_news_highlights_news_title',
		array(
			'selector'            => '.news-highlights span.highlights-title',
			'settings'            => 'hourly_news_highlights_news_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Highlights news content type settings.
$wp_customize->add_setting(
	'hourly_news_highlights_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_highlights_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'hourly-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'hourly-news' ),
		'section'         => 'hourly_news_highlights_section',
		'type'            => 'select',
		'active_callback' => 'hourly_news_if_highlights_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'hourly-news' ),
			'category' => esc_html__( 'Category', 'hourly-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Highlights news post setting.
	$wp_customize->add_setting(
		'hourly_news_highlights_news_post_' . $i,
		array(
			'sanitize_callback' => 'hourly_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'hourly_news_highlights_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'hourly-news' ), $i ),
			'section'         => 'hourly_news_highlights_section',
			'type'            => 'select',
			'choices'         => hourly_news_get_post_choices(),
			'active_callback' => 'hourly_news_highlights_news_section_content_type_post_enabled',
		)
	);

}

// Highlights news category setting.
$wp_customize->add_setting(
	'hourly_news_highlights_news_category',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_highlights_news_category',
	array(
		'label'           => esc_html__( 'Category', 'hourly-news' ),
		'section'         => 'hourly_news_highlights_section',
		'type'            => 'select',
		'choices'         => hourly_news_get_post_cat_choices(),
		'active_callback' => 'hourly_news_highlights_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function hourly_news_if_highlights_news_enabled( $control ) {
	return $control->manager->get_setting( 'hourly_news_highlights_news_section_enable' )->value();
}
function hourly_news_highlights_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_highlights_news_content_type' )->value();
	return hourly_news_if_highlights_news_enabled( $control ) && ( 'post' === $content_type );
}
function hourly_news_highlights_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_highlights_news_content_type' )->value();
	return hourly_news_if_highlights_news_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'hourly_news_highlights_news_title_text_partial' ) ) :
	// Title.
	function hourly_news_highlights_news_title_text_partial() {
		return esc_html( get_theme_mod( 'hourly_news_highlights_news_title' ) );
	}
endif;
