<?php
/**
 * Frontpage Customizer Settings
 *
 * @package Hourly News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'hourly_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'hourly-news' ),
		'panel' => 'hourly_news_frontpage_panel',
	)
);

// Banner section enable settings.
$wp_customize->add_setting(
	'hourly_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'hourly_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Hourly_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'hourly_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'hourly-news' ),
			'type'     => 'checkbox',
			'settings' => 'hourly_news_banner_section_enable',
			'section'  => 'hourly_news_banner_section',
		)
	)
);

// Banner Slider Sub Heading.
$wp_customize->add_setting(
	'hourly_news_banner_slider_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Hourly_News_Section_Sub_Heading_Control(
		$wp_customize,
		'hourly_news_banner_slider_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Slider Section', 'hourly-news' ),
			'settings'        => 'hourly_news_banner_slider_sub_heading',
			'section'         => 'hourly_news_banner_section',
			'active_callback' => 'hourly_news_if_banner_enabled',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'hourly_news_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'hourly-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'hourly-news' ),
		'section'         => 'hourly_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'hourly_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'hourly-news' ),
			'category' => esc_html__( 'Category', 'hourly-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'hourly_news_banner_slider_post_' . $i,
		array(
			'sanitize_callback' => 'hourly_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'hourly_news_banner_slider_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'hourly-news' ), $i ),
			'section'         => 'hourly_news_banner_section',
			'type'            => 'select',
			'choices'         => hourly_news_get_post_choices(),
			'active_callback' => 'hourly_news_banner_slider_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'hourly_news_banner_slider_category',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_banner_slider_category',
	array(
		'label'           => esc_html__( 'Category', 'hourly-news' ),
		'section'         => 'hourly_news_banner_section',
		'type'            => 'select',
		'choices'         => hourly_news_get_post_cat_choices(),
		'active_callback' => 'hourly_news_banner_slider_content_type_category_enabled',
	)
);

// Banner Posts Sub Heading.
$wp_customize->add_setting(
	'hourly_news_banner_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Hourly_News_Section_Sub_Heading_Control(
		$wp_customize,
		'hourly_news_banner_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Posts Section', 'hourly-news' ),
			'settings'        => 'hourly_news_banner_posts_sub_heading',
			'section'         => 'hourly_news_banner_section',
			'active_callback' => 'hourly_news_if_banner_enabled',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'hourly_news_banner_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_banner_posts_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'hourly-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'hourly-news' ),
		'section'         => 'hourly_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'hourly_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'hourly-news' ),
			'category' => esc_html__( 'Category', 'hourly-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'hourly_news_banner_posts_post_' . $i,
		array(
			'sanitize_callback' => 'hourly_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'hourly_news_banner_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'hourly-news' ), $i ),
			'section'         => 'hourly_news_banner_section',
			'type'            => 'select',
			'choices'         => hourly_news_get_post_choices(),
			'active_callback' => 'hourly_news_banner_posts_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'hourly_news_banner_posts_category',
	array(
		'sanitize_callback' => 'hourly_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'hourly_news_banner_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'hourly-news' ),
		'section'         => 'hourly_news_banner_section',
		'type'            => 'select',
		'choices'         => hourly_news_get_post_cat_choices(),
		'active_callback' => 'hourly_news_banner_posts_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function hourly_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'hourly_news_banner_section_enable' )->value();
}
//Banner Slider
function hourly_news_banner_slider_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_banner_slider_content_type' )->value();
	return hourly_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function hourly_news_banner_slider_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_banner_slider_content_type' )->value();
	return hourly_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
//Banner Posts
function hourly_news_banner_posts_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_banner_posts_content_type' )->value();
	return hourly_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function hourly_news_banner_posts_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'hourly_news_banner_posts_content_type' )->value();
	return hourly_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
