<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- Header Area -->
    <header class="main-header <?php echo esc_attr(houdabusiness_sticky_menu()); ?>">
		<?php if ( function_exists( 'peccular_companion_activated' ) ) { ?>
			<button class="top-header-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".top-header"><i class="fa fa-ellipsis-v"></i></button>
		<?php } ?>	


			<?php 
				$houdabusiness_topheader_text = get_theme_mod('houdabusiness_topheader_text','You Have problems, we have the solution');
				$houdabusiness_topheader_phn = get_theme_mod('houdabusiness_topheader_phn','264 654 9465');
				$houdabusiness_topheader_phnicon = get_theme_mod('houdabusiness_topheader_phnicon','fa fa-volume-control-phone');
				$houdabusiness_topheader_phnbtmtxt = get_theme_mod('houdabusiness_topheader_phnbtmtxt','request on call back');
				$houdabusiness_topheader_email = get_theme_mod('houdabusiness_topheader_email','Write Us');
				$houdabusiness_topheader_mailicon = get_theme_mod('houdabusiness_topheader_mailicon','fa fa-envelope-o');
				$houdabusiness_topheader_mailbtmtxt = get_theme_mod('houdabusiness_topheader_mailbtmtxt','info@business');
				$houdabusiness_topheader_icon1 = get_theme_mod('houdabusiness_topheader_icon1','fa fa-facebook');
				$houdabusiness_topheader_icon1_link = get_theme_mod('houdabusiness_topheader_icon1_link','#');
				$houdabusiness_topheader_icon2 = get_theme_mod('houdabusiness_topheader_icon2','fa fa-instagram');
				$houdabusiness_topheader_icon2_link = get_theme_mod('houdabusiness_topheader_icon2_link','#');
				$houdabusiness_topheader_icon3 = get_theme_mod('houdabusiness_topheader_icon3','fa fa-twitter');
				$houdabusiness_topheader_icon3_link = get_theme_mod('houdabusiness_topheader_icon3_link','#');
				$houdabusiness_topheader_icon4 = get_theme_mod('houdabusiness_topheader_icon4','fa fa-google-plus');
				$houdabusiness_topheader_icon4_link = get_theme_mod('houdabusiness_topheader_icon4_link','#');
				$houdabusiness_topheader_icon5 = get_theme_mod('houdabusiness_topheader_icon5','fa fa-youtube-play');
				$houdabusiness_topheader_icon5_link = get_theme_mod('houdabusiness_topheader_icon5_link','#');


				$houdabusiness_topheader_phniconcolor = get_theme_mod('houdabusiness_topheader_phniconcolor','#3a6eff');
				$houdabusiness_topheader_mailiconcolor = get_theme_mod('houdabusiness_topheader_mailiconcolor','#3a6eff');



			?>
		
			<!-- top header -->
			<div class="topheader">
				<div class="container"> 
					<div class="row">
						<div class="col-md-3 col-lg-3 col-sm-6 border-right space">
							<p><?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_text); ?></p>
						</div>
						<div class="col-md-3 col-lg-3 col-sm-6 border-right space">
							<a href="tel:<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phn); ?>">
								<div class="row">
									<div class="col-md-2 col-lg-2 col-sm-2">
										<i style="color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phniconcolor); ?>" class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phnicon); ?>" aria-hidden="true"></i>
									</div>
									<div class="col-md-10 col-lg-10 col-sm-10">
										<p class="houdabusiness-phone-label"><?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phn); ?></p>
										<p class="houdabusiness-phone-text"><?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phnbtmtxt); ?></p>
									</div>
								</div>
							</a>
						</div>
						<div class="col-md-3 col-lg-3 col-sm-6 border-right space">
							<a href="mailto:<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailbtmtxt); ?>">
								<div class="row">
									<div class="col-md-2 col-lg-2 col-sm-2">
										<i style="color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailiconcolor); ?>" class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailicon); ?>" aria-hidden="true"></i>
									</div>
									<div class="col-md-10 col-lg-10 col-sm-10">
										<p class="houdabusiness-email-label"><?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_email); ?></p>
										<p class="houdabusiness-email-text"><?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailbtmtxt); ?></p>
									</div>
								</div>
							</a>
						</div>
						<div class="col-md-3 col-lg-3 col-sm-6 socials space">

							<a href="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon1_link); ?>">
								<i class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon1); ?>" aria-hidden="true"></i>
							</a>

							<a href="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon2_link); ?>">
								<i class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon2); ?>" aria-hidden="true"></i>
							</a>

							<a href="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon3_link); ?>">
								<i class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon3); ?>" aria-hidden="true"></i>
							</a>

							<a href="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon4_link); ?>">
								<i class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon4); ?>" aria-hidden="true"></i>
							</a>

							<a href="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon5_link); ?>">
								<i class="<?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_icon5); ?>" aria-hidden="true"></i>
							</a>

						</div>
					</div>
				</div>
			</div>

           <!-- Header -->
            <nav class="navbar navbar-expand-lg navbaroffcanvase">
            	<div class="container">
					<div class="logo border-right">
						<?php
						if(has_custom_logo())
							{	
								the_custom_logo();
							}
							else { 
							?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<h4 class="site-title">
									<?php 
										echo esc_html(bloginfo('name'));
									?>
								</h4>
							</a>	
						<?php 						
							}
						?>
						<?php
							$houdabusiness_site_desc = get_bloginfo( 'description');
							if ($houdabusiness_site_desc) : ?>
								<p class="site-description"><?php echo esc_html($houdabusiness_site_desc); ?></p>
						<?php endif; ?>
					</div>
					
	                <div class="navbar-menubar">
	                    <!-- Small Divice Menu-->
	                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','houdabusiness'); ?>"> 
	                        <i class="fa fa-bars"></i>
	                    </button>
	                    <div class="collapse navbar-collapse navbar-menu">
		                    <button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','houdabusiness'); ?>"> 
		                        <i class="fa fa-times"></i>
		                    </button> 
							<?php 
								wp_nav_menu( 
									array(  
										'theme_location' => 'primary_menu',
										'container'  => '',
										'container_id'    => '',
										'menu_class' => 'navbar-nav main-nav',
										'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
										'walker' => new WP_Bootstrap_Navwalker()
										 ) 
									);
							?>
	                    </div>
	                </div>
            	</div>
            </nav>
    </header>