<?php


function houdabusiness_header_settings( $wp_customize ) {

$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'houdabusiness'),
		) 
	);

	
	/*=========================================
	Houdabusiness Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','houdabusiness'),
			'panel'  		=> 'header_section',
		)
    );
		

	// topheader Logo Width
    $wp_customize->add_setting('topheader_logowidth',array(
        'default' => 100,
        'sanitize_callback' => 'houdabusiness_sanitize_float'
    ));
    $wp_customize->add_control(new houdabusiness_Custom_Control( $wp_customize, 'topheader_logowidth',array(
	    'label' => __('Logo Width','houdabusiness'),
	    'section' => 'title_tagline',
	    'input_attrs' => array(
	            'min' => 0,
	            'max' => 500,
	            'step' => 1,
	        ),
    )));


    // top header Site Title Color
	$topheadersitetitlecol = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
    	'topheader_sitetitlecol',
    	array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
		    'label'   		=> __('Site Title Color','houdabusiness'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
    	'topheader_taglinecol',
    	array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
		    'label'   		=> __('Tagline Color','houdabusiness'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	



	/*=========================================
	Houdabusiness Top header
	=========================================*/
	$wp_customize->add_section(
        'houdabusiness_topheader',
        array(
        	'priority'      => 5,
            'title' 		=> __('Top Header','houdabusiness'),
			'panel'  		=> 'header_section',
		)
    );	


	$wp_customize->add_setting('houdabusiness_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));
	$wp_customize->add_control(new Houdabusiness_Tab_Control($wp_customize, 'houdabusiness_top_header_tabs', array(
	   'section' => 'houdabusiness_topheader',
	   'priority' => 1,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'houdabusiness'),
         	'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'hide_show_sticky',
            	'houdabusiness_topheader_text',
            	'houdabusiness_topheader_phn',
            	'houdabusiness_topheader_phnicon',
            	'houdabusiness_topheader_phnbtmtxt',
            	'houdabusiness_topheader_email',
            	'houdabusiness_topheader_mailicon',
            	'houdabusiness_topheader_mailbtmtxt',
            	'houdabusiness_topheader_icon1',
            	'houdabusiness_topheader_icon1_link',
            	'houdabusiness_topheader_icon2',
            	'houdabusiness_topheader_icon2_link',
            	'houdabusiness_topheader_icon3',
            	'houdabusiness_topheader_icon3_link',
            	'houdabusiness_topheader_icon4',
            	'houdabusiness_topheader_icon4_link',
            	'houdabusiness_topheader_icon5',
            	'houdabusiness_topheader_icon5_link',

            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'houdabusiness'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
            	'topheader_stickybgcolor',
            	'houdabusiness_topheader_bgcolor',
            	'houdabusiness_topheader_titlecolor',
            	'houdabusiness_topheader_phniconcolor',
            	'houdabusiness_topheader_phncolor',
            	'houdabusiness_topheader_phntextcolor',
				'houdabusiness_topheader_phntextbordercolor',
            	'houdabusiness_topheader_mailiconcolor',
            	'houdabusiness_topheader_mailcolor',
            	'houdabusiness_topheader_mailtextcolor',
            	'houdabusiness_topheader_socialiconcolor',
            	'houdabusiness_topheader_socialiconhovercolor',
            	'houdabusiness_topheader_bordercolor',
            	'houdabusiness_topheader_menuscolor',
            	'houdabusiness_topheader_menushoverbordercolor',
            	'houdabusiness_topheader_submenuscolor',
            	'houdabusiness_topheader_submenusbgcolor',
            	'houdabusiness_topheader_submenushovercolor',
            	'houdabusiness_topheader_submenusbordercolor'
            ),
         )
	    
    	),
	)));

	// All General

	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'houdabusiness_switch_sanitization'
   	) );
   	$wp_customize->add_control( new houdabusiness_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','houdabusiness' ),
        'section' => 'houdabusiness_topheader'
   	)));


	// topheader txt
	$wp_customize->add_setting( 'houdabusiness_topheader_text',array(
		'default' => __('You Have problems, we have the solution','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_text',array(
		'label' => __( 'Title','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));

	// topheader Phone Number
   	$wp_customize->add_setting( 'houdabusiness_topheader_phn',array(
		'default' => __('264 654 9465','houdabusiness' ),
		'sanitize_callback' => 'houdabusiness_sanitize_phone_number'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_phn',array(
		'label' => __( 'Phone Number','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	
 

	// topheader phone number icon
   	$wp_customize->add_setting( 'houdabusiness_topheader_phnicon',array(
		'default' => __('fa fa-volume-control-phone','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_phnicon',array(
		'label' => __( 'Phone Number Icon','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

	// topheader Phone Number bottom txt
   	$wp_customize->add_setting( 'houdabusiness_topheader_phnbtmtxt',array(
		'default' => __('request on call back','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_phnbtmtxt',array(
		'label' => __( 'Phone Number Bottom Text','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

  	// topheader Email
   	$wp_customize->add_setting( 'houdabusiness_topheader_email',array(
		'default' => __('Write Us','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_email',array(
		'label' => __( 'Email','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	
	

	// topheader mail icon
   	$wp_customize->add_setting( 'houdabusiness_topheader_mailicon',array(
		'default' => __('fa fa-envelope-o','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_mailicon',array(
		'label' => __( 'EMail Icon','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));		


	// topheader Mail bottom txt
   	$wp_customize->add_setting( 'houdabusiness_topheader_mailbtmtxt',array(
		'default' => __('info@gmail.com','houdabusiness' ),
		'sanitize_callback' => 'sanitize_email'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_mailbtmtxt',array(
		'label' => __( 'Email Id','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));		

	// topheader icon 1
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon1',array(
		'default' => __('fa fa-facebook','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon1',array(
		'label' => __( 'Icon 1','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	


   // topheader icon 1 Link
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon1_link',array(
		'default' => __('#','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon1_link',array(
		'label' => __( 'Icon 1 Link','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	


	// topheader icon 2
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon2',array(
		'default' => __('fa fa-instagram','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon2',array(
		'label' => __( 'Icon 2','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

   // topheader icon 2 Link
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon2_link',array(
		'default' => __('#','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon2_link',array(
		'label' => __( 'Icon 2 Link','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

	// topheader icon 3
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon3',array(
		'default' => __('fa fa-twitter','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon3',array(
		'label' => __( 'Icon 3','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

   // topheader icon 3 Link
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon3_link',array(
		'default' => __('#','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon3_link',array(
		'label' => __( 'Icon 3 Link','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	


	// topheader icon 4
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon4',array(
		'default' => __('fa fa-google-plus','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon4',array(
		'label' => __( 'Icon 4','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));

   // topheader icon 4 Link
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon4_link',array(
		'default' => __('#','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon4_link',array(
		'label' => __( 'Icon 4 Link','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

	// topheader icon 5
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon5',array(
		'default' => __('fa fa-youtube-play','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon5',array(
		'label' => __( 'Icon 5','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

   // topheader icon 5 Link
   	$wp_customize->add_setting( 'houdabusiness_topheader_icon5_link',array(
		'default' => __('#','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
   ) );
   $wp_customize->add_control( 'houdabusiness_topheader_icon5_link',array(
		'label' => __( 'Icon 5 Link','houdabusiness' ),
		'type' => 'text',
		'section' => 'houdabusiness_topheader'
   ));	

	// All Colors

   // topheader sticky bg color
	$topheaderstickybgcolor = esc_html__('#000', 'houdabusiness' );
	$wp_customize->add_setting(
    	'topheader_stickybgcolor',
    	array(
			'default' => $topheaderstickybgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'topheader_stickybgcolor',
		array(
		    'label'   		=> __('Sticky Header BG Color','houdabusiness'),
		    'section'		=> 'houdabusiness_topheader',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader bg color
	$wp_customize->add_setting( 'houdabusiness_topheader_bgcolor', array(
	   'default' => '#000',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_bgcolor', array(
  		'label' => __('BG Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader title color
	$wp_customize->add_setting( 'houdabusiness_topheader_titlecolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_titlecolor', array(
  		'label' => __('Title Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

	// topheader phone number icon color
	$wp_customize->add_setting( 'houdabusiness_topheader_phniconcolor', array(
	   'default' => '#3a6eff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_phniconcolor', array(
  		'label' => __('Phone Number Icon Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader phone number color
	$wp_customize->add_setting( 'houdabusiness_topheader_phncolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_phncolor', array(
  		'label' => __('Phone Number Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader phone number text color
	$wp_customize->add_setting( 'houdabusiness_topheader_phntextcolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_phntextcolor', array(
  		'label' => __('Phone Number Text Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

	// topheader phone number text border color
	$wp_customize->add_setting( 'houdabusiness_topheader_phntextbordercolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_phntextbordercolor', array(
  		'label' => __('Phone Number Text Border Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));


	// topheader mail icon color
	$wp_customize->add_setting( 'houdabusiness_topheader_mailiconcolor', array(
	   'default' => '#3a6eff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_mailiconcolor', array(
  		'label' => __('Mail Icon Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader mail color
	$wp_customize->add_setting( 'houdabusiness_topheader_mailcolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_mailcolor', array(
  		'label' => __('Mail Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader mailtext color
	$wp_customize->add_setting( 'houdabusiness_topheader_mailtextcolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_mailtextcolor', array(
  		'label' => __('Mail Text Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader socialicon color
	$wp_customize->add_setting( 'houdabusiness_topheader_socialiconcolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_socialiconcolor', array(
  		'label' => __('Socials Icon Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader socialiconhover color
	$wp_customize->add_setting( 'houdabusiness_topheader_socialiconhovercolor', array(
	   'default' => '#ee5635',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_socialiconhovercolor', array(
  		'label' => __('Socials Icon Hover Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader border color
	$wp_customize->add_setting( 'houdabusiness_topheader_bordercolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_bordercolor', array(
  		'label' => __('Border Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader menus color
	$wp_customize->add_setting( 'houdabusiness_topheader_menuscolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_menuscolor', array(
  		'label' => __('Menus Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader menushoverborder color
	$wp_customize->add_setting( 'houdabusiness_topheader_menushoverbordercolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_menushoverbordercolor', array(
  		'label' => __('Menus Hover Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader submenus color
	$wp_customize->add_setting( 'houdabusiness_topheader_submenuscolor', array(
	   'default' => '#fff',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_submenuscolor', array(
  		'label' => __('SubMenus Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader submenusbg color
	$wp_customize->add_setting( 'houdabusiness_topheader_submenusbgcolor', array(
	   'default' => '#000',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_submenusbgcolor', array(
  		'label' => __('SubMenus BG Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader submenushover color
	$wp_customize->add_setting( 'houdabusiness_topheader_submenushovercolor', array(
	   'default' => '#f5ad41',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_submenushovercolor', array(
  		'label' => __('SubMenus Hover Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));

  	// topheader submenusborder color
	$wp_customize->add_setting( 'houdabusiness_topheader_submenusbordercolor', array(
	   'default' => '#081c75',
	   'sanitize_callback' => 'sanitize_hex_color'
  	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'houdabusiness_topheader_submenusbordercolor', array(
  		'label' => __('SubMenus Border Color','houdabusiness'),
	   'section' => 'houdabusiness_topheader',
  	)));




	$wp_customize->register_control_type('Houdabusiness_Tab_Control');
	$wp_customize->register_panel_type( 'Houdabusiness_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'Houdabusiness_WP_Customize_Section' );	
	

}
add_action( 'customize_register', 'houdabusiness_header_settings' );




if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class Houdabusiness_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'houdabusiness_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class Houdabusiness_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'houdabusiness_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}