<?php
function houdabusiness_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
			'houdabusiness_frontpage_sections', array(
				'priority' => 32,
				'title' => esc_html__( 'Frontpage Sections', 'houdabusiness' ),
			)
		);
	 
 

	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'houdabusiness' ),
			'priority' => 13,
			'panel' => 'houdabusiness_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('houdabusiness_top_slier_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	 ));
	 $wp_customize->add_control(new Houdabusiness_Tab_Control($wp_customize, 'houdabusiness_top_slier_tabs', array(
		'section' => 'slider_setting',
		'priority' => 1,
		'buttons' => array(
		   array(
			  'name' => esc_html__('General', 'houdabusiness'),
			  'icon' => 'dashicons dashicons-welcome-write-blog',
			 'fields' => array(
				 'slider1',
				 'slider2',
				 'slider3',
				 'slider4',
				 'slider5'
			 ),
			 'active' => true,
		  ),
		   array(
			 'name' => esc_html__('Style', 'houdabusiness'),
			 'icon' => 'dashicons dashicons-art',
			 'fields' => array(
				 'slider_titlecolor',
				 'slider_descriptioncolor',
				 'slider_buttontextcolor',
				 'slider_buttonbgcolor',
				 'slider_buttontexthrvcolor',
				 'slider_buttonbghrvcolor',
				 'slider_overlaycolor',
				 'slider_prevnextarrowcolor',
				 'slider_prevnextarrowhrvcolor'
			 ),
		  ),
			array(
			  'name' => esc_html__('Layout', 'houdabusiness'),
			  'icon' => 'dashicons dashicons-layout',
			  'fields' => array(
				  'slider_section_width'
			  ),
		    )
		 
		 ),
	 )));
 
	// All General

	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','houdabusiness'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','houdabusiness'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','houdabusiness'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','houdabusiness'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','houdabusiness'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);
	


	// All Colors

	// slider title color
	$slidertitlecolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_titlecolor',
		array(
			'default' => $slidertitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_titlecolor',
		array(
			'label'   		=> __('Title Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider description color
	$sliderdescriptioncolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_descriptioncolor',
		array(
			'default' => $sliderdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptioncolor',
		array(
			'label'   		=> __('Description Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider buttontext color
	$sliderbuttontextcolor = esc_html__('#000', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_buttontextcolor',
		array(
			'default' => $sliderbuttontextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_buttontextcolor',
		array(
			'label'   		=> __('Button Text Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider buttonbg color
	$sliderbuttonbgcolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_buttonbgcolor',
		array(
			'default' => $sliderbuttonbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_buttonbgcolor',
		array(
			'label'   		=> __('Button BG Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider buttontexthrv color
	$sliderbuttontexthrvcolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_buttontexthrvcolor',
		array(
			'default' => $sliderbuttontexthrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_buttontexthrvcolor',
		array(
			'label'   		=> __('Button Text Hover Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider buttonbghrv color
	$sliderbuttonbghrvcolor = esc_html__('#3a6eff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_buttonbghrvcolor',
		array(
			'default' => $sliderbuttonbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_buttonbghrvcolor',
		array(
			'label'   		=> __('Button BG Hover Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider overlay color
	$slideroverlaycolor = esc_html__('#3e72fb', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_overlaycolor',
		array(
			'default' => $slideroverlaycolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_overlaycolor',
		array(
			'label'   		=> __('Overlay Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	
	// slider prevnextarrow color
	$sliderprevnextarrowcolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_prevnextarrowcolor',
		array(
			'default' => $sliderprevnextarrowcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_prevnextarrowcolor',
		array(
			'label'   		=> __('Prev/Next Arrows Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider prevnextarrowhrv color
	$sliderprevnextarrowhrvcolor = esc_html__('#000', 'houdabusiness' );
	$wp_customize->add_setting(
		'slider_prevnextarrowhrvcolor',
		array(
			'default' => $sliderprevnextarrowhrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_prevnextarrowhrvcolor',
		array(
			'label'   		=> __('Prev/Next Arrows Hover Color','houdabusiness'),
			'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	
 

	// Layout
	$wp_customize->add_setting('slider_section_width',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'houdabusiness_sanitize_choices',
    ));
    $wp_customize->add_control('slider_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','houdabusiness'),
        'choices' => array (
            'Box Width' => __('Box Width','houdabusiness'),
            'Full Width' => __('Full Width','houdabusiness')
        ),
        'section' => 'slider_setting',
    ));


	


	/*=========================================
	Service Section
	=========================================*/
	$wp_customize->add_section(
		'Service_setting', array(
			'title' => esc_html__( 'Service Section', 'houdabusiness' ),
			'priority' => 14,
			'panel' => 'houdabusiness_frontpage_sections',
		)
	);

	$wp_customize->add_setting('houdabusiness_services_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));
	$wp_customize->add_control(new Houdabusiness_Tab_Control($wp_customize, 'houdabusiness_services_tabs', array(
		'section' => 'Service_setting',
		'priority' => 1,
		'buttons' => array(
			array(
				'name' => esc_html__('General', 'houdabusiness'),
				'icon' => 'dashicons dashicons-welcome-write-blog',
				'fields' => array(
					'Service1',
					'Service2',
					'Service3',
					'Service4',
					'Service5',
					'Service6',
					'houdabusiness_Service_btntext'
				),
				'active' => true,
			),
			array(
				'name' => esc_html__('Style', 'houdabusiness'),
				'icon' => 'dashicons dashicons-art',
				'fields' => array(
					'service_headingcolor',
					'service_descriptioncolor',
					'service_boximgbrdcolor',
					'service_boxtitlecolor',
					'service_boxdescriptioncolor',
					'service_boxbtntextcolor',
					'service_boxbtnbgcolor',
					'service_boxbtnbghrvcolor',
					'service_boxbgcolor'
				),
			),
			array(
			  'name' => esc_html__('Layout', 'houdabusiness'),
			  'icon' => 'dashicons dashicons-layout',
			  'fields' => array(
				  'Service_section_width',
				  'Service_section_padding',
				  'Service_section_top_padding',
				  'Service_section_bottom_padding'
			  ),
		    )
		
		),
	)));
 


	// Service 1
	$wp_customize->add_setting( 
    	'Service1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'Service1',
		array(
		    'label'   		=> __('Service 1','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Service 2
	$wp_customize->add_setting(
    	'Service2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'Service2',
		array(
		    'label'   		=> __('Service 2','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 3
	$wp_customize->add_setting(
    	'Service3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'Service3',
		array(
		    'label'   		=> __('Service 3','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 4
	$wp_customize->add_setting(
    	'Service4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'Service4',
		array(
		    'label'   		=> __('Service 4','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Service 5
	$wp_customize->add_setting(
    	'Service5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service5',
		array(
		    'label'   		=> __('Service 5','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// Service 6
	$wp_customize->add_setting(
    	'Service6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service6',
		array(
		    'label'   		=> __('Service 6','houdabusiness'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);

	// Service btn txt
	$wp_customize->add_setting( 'houdabusiness_Service_btntext',array(
		'default' => __('Read More','houdabusiness' ),
		'sanitize_callback' => 'sanitize_text_field'
	) );
	$wp_customize->add_control( 'houdabusiness_Service_btntext',array(
			'label' => __( 'Button Text','houdabusiness' ),
			'type' => 'text',
			'section' => 'Service_setting'
	));
	

	// service heading color
	$serviceheadingcolor = esc_html__('#000', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_headingcolor',
		array(
			'default' => $serviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_headingcolor',
		array(
			'label'   		=> __('Heading Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service description color
	$servicedescriptioncolor = esc_html__('#7a7879', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_descriptioncolor',
		array(
			'default' => $servicedescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_descriptioncolor',
		array(
			'label'   		=> __('Description Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boximgbrd color
	$serviceboximgbrdcolor = esc_html__('#3c73fc', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boximgbrdcolor',
		array(
			'default' => $serviceboximgbrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boximgbrdcolor',
		array(
			'label'   		=> __('Box Image Border Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxtitle color
	$serviceboxtitlecolor = esc_html__('#090b0a', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxtitlecolor',
		array(
			'default' => $serviceboxtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxtitlecolor',
		array(
			'label'   		=> __('Box Title Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxdescription color
	$serviceboxdescriptioncolor = esc_html__('#8a8a8c', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxdescriptioncolor',
		array(
			'default' => $serviceboxdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxdescriptioncolor',
		array(
			'label'   		=> __('Box Description Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxbtntext color
	$serviceboxbtntextcolor = esc_html__('#fff', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxbtntextcolor',
		array(
			'default' => $serviceboxbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxbtntextcolor',
		array(
			'label'   		=> __('Box Button Text Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxbtnbg color
	$serviceboxbtnbgcolor = esc_html__('#3d72fc', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxbtnbgcolor',
		array(
			'default' => $serviceboxbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxbtnbgcolor',
		array(
			'label'   		=> __('Box Button BG Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxbtnbghrv color
	$serviceboxbtnbghrvcolor = esc_html__('#000', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxbtnbghrvcolor',
		array(
			'default' => $serviceboxbtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxbtnbghrvcolor',
		array(
			'label'   		=> __('Box Button BG Hover Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service boxbg color
	$serviceboxbgcolor = esc_html__('#f3f4f9', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_boxbgcolor',
		array(
			'default' => $serviceboxbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_boxbgcolor',
		array(
			'label'   		=> __('Box BG Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


		// service Hover overlay color
	$serviceHoveroverlycolor = esc_html__('#3d72fc', 'houdabusiness' );
	$wp_customize->add_setting(
		'service_hoveroverlycolor',
		array(
			'default' => $serviceHoveroverlycolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'service_hoveroverlycolor',
		array(
			'label'   		=> __('Image Hover Overlay Color','houdabusiness'),
			'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	



	// Layout
	$wp_customize->add_setting('Service_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'houdabusiness_sanitize_choices',
    ));
    $wp_customize->add_control('Service_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','houdabusiness'),
        'choices' => array (
            'Box Width' => __('Box Width','houdabusiness'),
            'Full Width' => __('Full Width','houdabusiness')
        ),
        'section' => 'Service_setting',
    ));


    // service section padding 
	$wp_customize->add_setting('Service_section_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('Service_section_padding',array(
		'label' => __('Section Padding','houdabusiness'),
		'section' => 'Service_setting'
	));

	$wp_customize->add_setting('Service_section_top_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('Service_section_top_padding',array(
		'type' => 'number',
		'label' => __('Top','houdabusiness'),
		'section' => 'Service_setting',
	));

		$wp_customize->add_setting('Service_section_bottom_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('Service_section_bottom_padding',array(
		'type' => 'number',
		'label' => __('Bottom','houdabusiness'),
		'section' => 'Service_setting',
	));


}

add_action( 'customize_register', 'houdabusiness_blog_setting' );

// service selective refresh
function houdabusiness_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'houdabusiness_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'houdabusiness_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'houdabusiness_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'houdabusiness_blog_section_partials' );

// blog_title
function houdabusiness_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function houdabusiness_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function houdabusiness_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}