<?php
function houdabusiness_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'houdabusiness_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'fffeff',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'houdabusiness_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'houdabusiness_custom_header_setup' );

if ( ! function_exists( 'houdabusiness_header_style' ) ) :

function houdabusiness_header_style() {
	$header_text_color = get_header_textcolor();

	$topheader_logowidth = esc_attr(get_theme_mod('topheader_logowidth','100'));
	$topheader_sitetitlecol = esc_attr(get_theme_mod('topheader_sitetitlecol','#fff'));
	$topheader_taglinecol = esc_attr(get_theme_mod('topheader_taglinecol','#fff'));

	$houdabusiness_topheader_bgcolor = get_theme_mod('houdabusiness_topheader_bgcolor','#000');
	$houdabusiness_topheader_titlecolor = get_theme_mod('houdabusiness_topheader_titlecolor','#fff');
	$topheader_stickybgcolor = get_theme_mod('topheader_stickybgcolor','#000');
	$houdabusiness_topheader_phncolor = get_theme_mod('houdabusiness_topheader_phncolor','#fff');
	$houdabusiness_topheader_phntextcolor = get_theme_mod('houdabusiness_topheader_phntextcolor','#fff');
	$houdabusiness_topheader_phntextbordercolor = get_theme_mod('houdabusiness_topheader_phntextbordercolor','#fff');
	$houdabusiness_topheader_mailcolor = get_theme_mod('houdabusiness_topheader_mailcolor','#fff');
	$houdabusiness_topheader_mailtextcolor = get_theme_mod('houdabusiness_topheader_mailtextcolor','#fff');
	$houdabusiness_topheader_socialiconcolor = get_theme_mod('houdabusiness_topheader_socialiconcolor','#fff');

	$houdabusiness_topheader_socialiconhovercolor = get_theme_mod('houdabusiness_topheader_socialiconhovercolor','#ee5635');
	$houdabusiness_topheader_bordercolor = get_theme_mod('houdabusiness_topheader_bordercolor','#fff');
	$houdabusiness_topheader_menuscolor = get_theme_mod('houdabusiness_topheader_menuscolor','#fff');
	$houdabusiness_topheader_menushoverbordercolor = get_theme_mod('houdabusiness_topheader_menushoverbordercolor','#fff');
	$houdabusiness_topheader_submenuscolor = get_theme_mod('houdabusiness_topheader_submenuscolor','#fff');
	$houdabusiness_topheader_submenusbgcolor = get_theme_mod('houdabusiness_topheader_submenusbgcolor','#000');
	$houdabusiness_topheader_submenushovercolor = get_theme_mod('houdabusiness_topheader_submenushovercolor','#f5ad41');
	$houdabusiness_topheader_submenusbordercolor = get_theme_mod('houdabusiness_topheader_submenusbordercolor','#081c75');

 

	$slider_titlecolor = get_theme_mod('slider_titlecolor','#fff');
	$slider_descriptioncolor = get_theme_mod('slider_descriptioncolor','#fff');
	$slider_buttontextcolor = get_theme_mod('slider_buttontextcolor','#000');
	$slider_buttonbgcolor = get_theme_mod('slider_buttonbgcolor','#fff');
	$slider_buttontexthrvcolor = get_theme_mod('slider_buttontexthrvcolor','#fff');
	$slider_buttonbghrvcolor = get_theme_mod('slider_buttonbghrvcolor','#3a6eff');
	$slider_overlaycolor = get_theme_mod('slider_overlaycolor','#3e72fb');
	$slider_prevnextarrowcolor = get_theme_mod('slider_prevnextarrowcolor','#fff');
	$slider_prevnextarrowhrvcolor = get_theme_mod('slider_prevnextarrowhrvcolor','#000');


	$service_headingcolor = get_theme_mod('service_headingcolor','#000');
	$service_descriptioncolor = get_theme_mod('service_descriptioncolor','#7a7879');
	$service_boximgbrdcolor = get_theme_mod('service_boximgbrdcolor','#3c73fc');
	$service_boxtitlecolor = get_theme_mod('service_boxtitlecolor','#090b0a');
	$service_boxdescriptioncolor = get_theme_mod('service_boxdescriptioncolor','#8a8a8c');
	$service_boxbtntextcolor = get_theme_mod('service_boxbtntextcolor','#fff');
	$service_boxbtnbgcolor = get_theme_mod('service_boxbtnbgcolor','#3d72fc');
	$service_boxbtnbghrvcolor = get_theme_mod('service_boxbtnbghrvcolor','#000');
	$service_boxbgcolor = get_theme_mod('service_boxbgcolor','#f3f4f9');
	$service_hoveroverlycolor = get_theme_mod('service_hoveroverlycolor','#3d72fc');



	?>
	<style type="text/css">
		.main-header .topheader {
			background: <?php echo esc_attr( $houdabusiness_topheader_bgcolor ); ?>;
		}

		.main-header .topheader p {
			color: <?php echo esc_attr( $houdabusiness_topheader_titlecolor ); ?>;
		}

		.main-header.header-fixed {
			background: <?php echo esc_attr( $topheader_stickybgcolor ); ?>;
		}


		.main-header .logo img {
			width: <?php echo apply_filters('houdabusiness_topheader', $topheader_logowidth); ?>%;
			height: 100%;
		}

		.main-header h4.site-title {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_sitetitlecol); ?>;
		}

		.main-header p.site-description {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_taglinecol); ?>;
		}


		.main-header .topheader p.houdabusiness-phone-label {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phncolor); ?>;
		}

		.main-header .topheader p.houdabusiness-phone-text {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phntextcolor); ?>;
		}

		.main-header .topheader p.houdabusiness-phone-text {
			border-color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_phntextbordercolor); ?>;
		}

		.main-header .topheader p.houdabusiness-email-label {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailcolor); ?>;
		}

		.main-header .topheader p.houdabusiness-email-text {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_mailtextcolor); ?>;
		}

		.main-header .topheader .socials i.fa {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_socialiconcolor); ?>;
		}

		.main-header .topheader .socials i.fa:hover {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_socialiconhovercolor
); ?>;
		}

		.border-right,.main-header .topheader,.main-header .navbar {
			border-color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_bordercolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li a,.main-header .navbar .navbar-menu ul li.dropdown>a::after {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_menuscolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li a:before{
			background: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_menushoverbordercolor); ?>;
		}
		.main-header .navbar .navbar-nav > li:hover a {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_menushoverbordercolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_submenuscolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu {
			background: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_submenusbgcolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover {
			color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_submenushovercolor); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu {
			border-color: <?php echo apply_filters('houdabusiness_topheader', $houdabusiness_topheader_submenusbordercolor); ?>;
		}


		.slider-area h2 {
			color: <?php echo esc_attr( $slider_titlecolor ); ?> !important;
		}

		.slider-area p {
			color: <?php echo esc_attr( $slider_descriptioncolor ); ?> !important;
		}

		.hero-style a.ReadMore {
			color: <?php echo esc_attr( $slider_buttontextcolor ); ?> !important;
		}

		.hero-style a.ReadMore {
			background: <?php echo esc_attr( $slider_buttonbgcolor ); ?>;
		}

		.hero-style a.ReadMore:hover {
			color: <?php echo esc_attr( $slider_buttontexthrvcolor ); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			background: <?php echo esc_attr( $slider_buttonbghrvcolor ); ?>;
		}

		.hero-overlay, .hero-in-overlay {
			background: <?php echo esc_attr( $slider_overlaycolor ); ?>;
		}

		.hero-slider .swiper-button-prev, .hero-slider .swiper-button-next,
		.hero-slider .swiper-button-next:before, .hero-slider .swiper-button-prev:before {
			color: <?php echo esc_attr( $slider_prevnextarrowcolor ); ?>;
		}

		.hero-slider .swiper-button-prev:hover, .hero-slider .swiper-button-next:hover,
		.hero-slider .swiper-button-prev:hover:before, .hero-slider .swiper-button-next:hover:before {
			color: <?php echo esc_attr( $slider_prevnextarrowhrvcolor ); ?>;
		}


		#service-section .header-section .title {
			color: <?php echo esc_attr( $service_headingcolor ); ?>;
		}

		#service-section .header-section .description {
			color: <?php echo esc_attr( $service_descriptioncolor ); ?>;
		}

		#service-section .single-service .part-1 {
			border-color: <?php echo esc_attr( $service_boximgbrdcolor ); ?>;
		}

		#service-section .single-service .part-1:before,
		#service-section .single-service:hover .part-1:before {
			border-top-color: <?php echo esc_attr( $service_boximgbrdcolor ); ?>;
		}

		#service-section .single-service .part-2 h3.title {
			color: <?php echo esc_attr( $service_boxtitlecolor ); ?>;
		}

		#service-section .single-service .part-2 p {
			color: <?php echo esc_attr( $service_boxdescriptioncolor ); ?>;
		}

		#service-section .single-service .part-2 a {
			color: <?php echo esc_attr( $service_boxbtntextcolor ); ?>;
		}

		#service-section .single-service .part-2 a {
			background: <?php echo esc_attr( $service_boxbtnbgcolor ); ?>;
		}

		#service-section .single-service .part-2 a:hover {
			background: <?php echo esc_attr( $service_boxbtnbghrvcolor ); ?>;
		}

		#service-section .single-service .part-2 {
			background: <?php echo esc_attr( $service_boxbgcolor ); ?>;
		}
		#service-section .single-service:hover .part-1{
		background: <?php echo esc_attr( $service_hoveroverlycolor ); ?>;
	}

		#service-section {
			padding-top: <?php echo esc_attr(get_theme_mod('Service_section_top_padding')); ?>em !important;
		}

		#service-section {
			padding-bottom: <?php echo esc_attr(get_theme_mod('Service_section_bottom_padding')); ?>em !important;
		}





	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		h4.site-title,
		p.site-description {
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
		
	<?php endif; ?>


	</style>
	<?php
}
endif;
