<?php
/**
 * This file contains functions and hooks for styling Hootkit plugin
 *   Hootkit is a free plugin released under GPL license and hosted on wordpress.org.
 *
 * This file is loaded at 'after_setup_theme' action @priority 10 ONLY IF hootkit plugin is active
 *
 * @package    Hoot Business
 * @subpackage HootKit
 */

// Register HootKit
add_filter( 'hootkit_register', 'hootbiz_register_hootkit', 5 );
// The theme's main style is loaded @12
// The child's main style is loaded @18
add_action( 'wp_enqueue_scripts', 'hootbiz_enqueue_hootkit', 14 );
add_action( 'wp_enqueue_scripts', 'hootbiz_enqueue_childhootkit', 20 );

// Add dynamic CSS for hootkit
add_action( 'hoot_dynamic_cssrules', 'hootbiz_hootkit_dynamic_cssrules', 6 );
// Set dynamic css handle to hootkit
// Set dynamic css handle to child hootkit inside `hootbiz_dynamic_css_hootkit_handle` using `hootbiz_dynamic_css_childhootkit_handle` 
add_filter( 'hoot_style_builder_inline_style_handle', 'hootbiz_dynamic_css_hootkit_handle', 2 );

/**
 * Register Hootkit
 *
 * @since 1.0
 * @param array $config
 * @return string
 */
if ( !function_exists( 'hootbiz_register_hootkit' ) ) :
function hootbiz_register_hootkit( $config ) {
	// Array of configuration settings.
	$config = array(
		'nohoot'    => false,
		'theme_css' => true,
		'modules'   => array(
			'sliders'     => array( 'image', 'postimage' ),
			'widgets'     => array( 'announce', 'content-blocks', 'content-posts-blocks', 'cta', 'icon', 'post-grid', 'post-list', 'social-icons', 'ticker', 'content-grid', 'cover-image', 'profile', 'ticker-posts', ),
		),
		'supports'  => array( 'post-grid-firstpost-slider', 'announce-headline', 'grid-widget', 'list-widget' ),
		'premium'   => array( 'carousel', 'postcarousel', 'postlistcarousel', 'contact-info', 'number-blocks', 'vcards', 'buttons', 'icon-list', 'notice', 'toggle', 'tabs', ),
	);
	return $config;
}
endif;

/**
 * Enqueue Scripts and Styles
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'hootbiz_enqueue_hootkit' ) ) :
function hootbiz_enqueue_hootkit() {

	$loadminified = ( defined( 'HOOT_DEBUG' ) ) ?
					( ( HOOT_DEBUG ) ? false : true ) :
					hoot_get_mod( 'load_minified', 0 );

	/* Load Hootkit Style */
	if ( $loadminified && file_exists( hoot_data()->template_dir . 'hootkit/hootkit.min.css' ) )
		$style_uri =  hoot_data()->template_uri . 'hootkit/hootkit.min.css';
	elseif ( file_exists( hoot_data()->template_dir . 'hootkit/hootkit.css' ) )
		$style_uri =  hoot_data()->template_uri . 'hootkit/hootkit.css';
	if ( !empty( $style_uri ) )
		wp_enqueue_style( 'hootbiz-hootkit', $style_uri, array(), hoot_data()->template_version );

}
endif;
if ( !function_exists( 'hootbiz_enqueue_childhootkit' ) ) :
function hootbiz_enqueue_childhootkit() {
	if ( is_child_theme() ) :

	$loadminified = ( defined( 'HOOT_DEBUG' ) ) ?
					( ( HOOT_DEBUG ) ? false : true ) :
					hoot_get_mod( 'load_minified', 0 );

	/* Load Hootkit Style */
	if ( $loadminified && file_exists( hoot_data()->child_dir . 'hootkit/hootkit.min.css' ) )
		$style_uri =  hoot_data()->child_uri . 'hootkit/hootkit.min.css';
	elseif ( file_exists( hoot_data()->child_dir . 'hootkit/hootkit.css' ) )
		$style_uri =  hoot_data()->child_uri . 'hootkit/hootkit.css';
	if ( !empty( $style_uri ) ) {
		wp_enqueue_style( 'hootbiz-child-hootkit', $style_uri, array(), hoot_data()->childtheme_version );
		add_filter( 'hoot_style_builder_inline_style_handle', 'hootbiz_dynamic_css_childhootkit_handle', 10 );
	}

	endif;
}
endif;

/**
 * Set dynamic css handle to hootkit
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'hootbiz_dynamic_css_hootkit_handle' ) ) :
function hootbiz_dynamic_css_hootkit_handle( $handle ) {
	return 'hootbiz-hootkit';
}
endif;
if ( !function_exists( 'hootbiz_dynamic_css_childhootkit_handle' ) ) :
function hootbiz_dynamic_css_childhootkit_handle( $handle ) {
	return 'hootbiz-child-hootkit';
}
endif;

/**
 * Custom CSS built from user theme options for hootkit features
 * For proper sanitization, always use functions from library/sanitization.php
 *
 * @since 1.0
 * @access public
 */
if ( !function_exists( 'hootbiz_hootkit_dynamic_cssrules' ) ) :
function hootbiz_hootkit_dynamic_cssrules() {

	// Get user based style values
	$styles = hootbiz_user_style();
	extract( $styles );

	/*** Add Dynamic CSS ***/

	hoot_add_css_rule( array(
						'selector'  => '.flycart-toggle, .flycart-panel',
						'property'  => 'background',
						'value'     => $content_bg_color,
				) );

	/* Light Slider */

	hoot_add_css_rule( array(
						'selector'  => '.lSSlideOuter ul.lSPager.lSpg > li:hover a, .lSSlideOuter ul.lSPager.lSpg > li.active a',
						'property'  => 'background-color',
						'value'     => $accent_color,
						'idtag'     => 'accent_color',
					) );


	/* Sidebars and Widgets */

	hoot_add_css_rule( array(
						'selector'  => '.widget .viewall a',
						'property'  => 'background',
						'value'     => $content_bg_color,
					) );
	hoot_add_css_rule( array(
						'selector'  => '.widget .viewall a:hover',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background' => array( $accent_font, 'accent_font' ),
							'color'      => array( $accent_color, 'accent_color' ),
							),
					) );

	if ( !empty( $widgetmargin ) ) :
		hoot_add_css_rule( array(
						'selector'  => '.bottomborder-line:after' . ',' . '.bottomborder-shadow:after',
						'property'  => 'margin-top',
						'value'     => $widgetmargin,
						'idtag'     => 'widgetmargin',
					) );
		hoot_add_css_rule( array(
						'selector'  => '.topborder-line:before' . ',' . '.topborder-shadow:before',
						'property'  => 'margin-bottom',
						'value'     => $widgetmargin,
						'idtag'     => 'widgetmargin',
					) );
	endif;

	hoot_add_css_rule( array(
						'selector'  => '.cta-subtitle',
						'property'  => 'color',
						'value'     => $accent_color,
						'idtag'     => 'accent_color',
					) );

	hoot_add_css_rule( array(
						'selector' => '.content-block-icon i',
						'property' => 'color',
						'value'    => $accent_color,
						'idtag'    => 'accent_color',
					) );

	hoot_add_css_rule( array(
						'selector' => '.icon-style-circle' .',' . '.icon-style-square',
						'property' => 'border-color',
						'value'    => $accent_color,
						'idtag'    => 'accent_color',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.content-block-style3 .content-block-icon',
						'property'  => 'background',
						'value'     => $content_bg_color,
					) );

}
endif;