<?php
/**
 * Template Name: Teams List Template
 */
get_header(); 

if ( home_services_set_pro_active() ) {
$home_services_team_list_sidebar_position = get_theme_mod('team_page_sidebar_layout','team-page-sidebar-right');
if($home_services_team_list_sidebar_position == 'team-page-sidebar-left' || $home_services_team_list_sidebar_position =='team-page-sidebar-right'){
    $team_list_content_class = 'col-sm-8';
    $team_list_align_class='';
}else{
    $team_list_content_class = 'col-sm-12';
    $team_list_align_class='text-center';
}
?>

<div class="inside-page content-area team-archive">
    <div class="container">
        <?php if($home_services_team_list_sidebar_position == 'team-page-sidebar-left'){?>
             <div class="col-sm-4 left-sidebar"><?php
                home_services_team_list_sidebar();
              ?></div>
        <?php } ?>
       
        <!-- start of main content -->
        <div class="main-content <?php echo esc_attr($team_list_content_class);?>" id="primary">
            <div class="row">
            	<div class="col-sm-12 team-list-header">
                    <h2><?php  the_title();?> </h2>
                    <p><?php the_content();?></p>
            	</div>
                <div class="col-sm-12 teams-list text-center">
                    <?php get_template_part( 'template-parts/content-page', 'team' ); ?>
                </div>
            </div>
        </div><!--end of main content -->
        <?php if($home_services_team_list_sidebar_position == 'team-page-sidebar-right'){?>
             <div class="col-sm-4 right-sidebar"><?php home_services_team_list_sidebar(); ?></div>
        <?php } ?>
    </div>
</div>


<?php 
}
get_footer();