<?php
if ( home_services_set_pro_active() ) {
	if(get_theme_mod('testimonial_show_hide') && get_theme_mod('testimonial_heading_text')){?>
		<div class="testimonial-wraper home-block">
			<div class="container">
				<div class="row">
					<div class="col-sm-4 testimonial-info">
						<?php 
							if(get_theme_mod('testimonial_heading_text')){
								echo '<h2>'.esc_html(get_theme_mod('testimonial_heading_text')).'</h2>';
							}
							if(get_theme_mod('desc_testimonial_section')){
								echo '<p>'.esc_html(get_theme_mod('desc_testimonial_section')).'</p>';
							}
						?>
					</div>
					<div class="col-sm-8 testimonial-carosuel">
						<div class="home-testimonial-layout-1 owl-carousel">
						    <?php
					            $seviceTag = get_theme_mod('home_services_testomonial_tags');
					            if(!empty($seviceTag)) {
								    $home_service_testimonial_args = array(
								        'post_type'      => 'abt_testimonials',
								        'post_status'    => 'publish',
								        'order'          => 'DESC',
								        'posts_per_page'	 => 3,
								        'tax_query'      => [
								            [
								                'taxonomy'   => 'service_tag',
								                'field'      => 'slug',
								                'terms'       => $seviceTag

								            ]
								        ]
								    );
								    $all_testimonial_posts = get_posts( $home_service_testimonial_args );
								}
								
								if(empty($all_testimonial_posts) || empty($seviceTag)){
									$extra_args = array(
								        'post_type'				=> 'abt_testimonials',
								  		'post_status'    => 'publish',
								        'ignore_sticky_posts'   => true,
								        'order'					=> 'DESC',
								        'posts_per_page'	 		=> 3,
								    );
								    $final_posts = new WP_Query( $extra_args );
								}else{
									$final_posts = new WP_Query( $home_service_testimonial_args );
								}   
				                if ( $final_posts->have_posts() ) :
					                while( $final_posts->have_posts() ):$final_posts->the_post();
						                $id = get_the_ID();
						                $taxonomy = 'service_tag';
						                $recent_terms = get_the_terms( $id, $taxonomy );
					                	$custom = get_post_custom(get_the_ID());?>
							            <div class="testimonial-holder">
							                
							                <div class="summary">
							                    <?php the_excerpt(); ?>
							                    <div class="img-holder">
							                    <?php if(has_post_thumbnail()){
							                        $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');
							                    ?>
							                    <img width="100" height="100" src="<?php echo esc_url($image_url[0]); ?>"
							                        class="attachment-full size-full wp-post-image" alt="" loading="lazy">
							                    <?php } ?>
							                </div>
							                    <h4 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
							                    <?php if ($custom['abt_source'][0]){ ?>
					                        	<span class="review-source"><a target = "_blank"
					                                href="<?php echo esc_url($custom['abt_source_link'][0]); ?>"><?php echo esc_html($custom['abt_source'][0]); ?></a></span>
						                        <?php }  
											        if ($recent_terms) {
											          echo '<ul>';
											          foreach ( $recent_terms as $term ) {
											            if ( isset( $term ) ) {
											              if ( isset( $term->name ) ) {
											                echo '<li>'.$term->name.'</li>';
											              }
											            }
											          }
											          echo '</ul>';
											        } ?>
							                </div>
							            </div>
					            	<?php endwhile;
					                wp_reset_postdata();  
					            endif;?>
					        </div>
					</div>
				</div>
			</div>
		</div>
	<?php } 
}?>