<?php
if ( home_services_set_pro_active() ) {
	if(get_theme_mod('home_services_team_show_hide') && get_theme_mod('home_services_team_heading_text')){?>
		<div class="teams-wraper home-block">
			<div class="container">
				<div class="row home-team-header">
					<div class="col-sm-12">
						<?php 
							if(get_theme_mod('home_services_team_heading_text')){
								echo '<h2>'.esc_html(get_theme_mod('home_services_team_heading_text')).'</h2>';
							}
							if(get_theme_mod('home_services_team_section_desc')){
								echo '<p>'.esc_html(get_theme_mod('home_services_team_section_desc')).'</p>';
							}
						?>
					</div>
				</div>
				<div class="row team-list">
					<div class="team-holder-wraper">
						<?php
			          
			           $team_args = array(
						        'post_type'				=> 'abt_team',
						  		'post_status'    => 'publish',
						        'order'					=> 'DESC',
						        'posts_per_page'	 		=> 3,
						    );
						$team_query = new WP_Query( $team_args );
						 
		                if ( $team_query->have_posts() ) :
		                while( $team_query->have_posts() ):$team_query->the_post();
		                $custom = get_post_custom(get_the_ID());?>
		                <a href="<?php the_permalink(); ?>" class="team-holder">
		                    <?php if(has_post_thumbnail()){
		                    	$summary_sub_class= 'with-thumbnails';?>
		                    	<div class="img-holder">
			                       <?php $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');?>
			                    		<img width="465" height="371" src="<?php echo esc_url($image_url[0]); ?>"
			                        class="attachment-full size-full wp-post-image" alt="" loading="lazy">
		                        </div>
		                    <?php } else{
		                    	$summary_sub_class= 'without-thumbnails';
		                    }?>
			                
			                <div class="summary <?php echo $summary_sub_class;?>">

			                    <h3 class="post-title"><?php the_title(); ?></h3>
			                    <span class="organization"><?php echo esc_html($custom['abt_position'][0]); ?></span>

			                   <p class="short-info"><?php echo esc_html(home_services_excerpt( 25 )); ?></p>

			                </div>
				        </a>
			            <?php
							endwhile;
			                wp_reset_postdata();  
			            endif;?>
			        </div>
				</div>
			</div>
		</div><!-- end of promotion-->
	<?php }
}?>