<?php
if ( home_services_set_pro_active() ) {
	if(get_theme_mod('promotion_show_hide') && get_theme_mod('promotion_heading_text')){?>
		<div class="promotion-wraper home-block">
			<div class="container">
				<div class="row home-pomotion-header">
					<div class="col-sm-8">
						<?php 
							if(get_theme_mod('promotion_heading_text')){
								echo '<h2>'.esc_html(get_theme_mod('promotion_heading_text')).'</h2>';
							}
							if(get_theme_mod('desc_promotion_section')){
								echo '<p>'.esc_html(get_theme_mod('desc_promotion_section')).'</p>';
							}
						?>
					</div>
					<div class="col-sm-4">
						<?php if(get_theme_mod('promotion_btn_text')){
									if(get_theme_mod('promotion_btn_text_link')){
										$promotion_all_link = get_theme_mod('promotion_btn_text_link');
									}else{
										$promotion_all_link='#';
									}?>
									<div class="button-group">
										<a class="btn promotion-btn" href="<?php echo esc_url($promotion_all_link);?>"> <?php echo esc_html(get_theme_mod('promotion_btn_text'));?></a>
									</div>
							<?php }
						?>
					</div>
				</div>
				<div class="row promotion-list">
					<div class="promotion-holder-wraper">
						<?php
			            $seviceTag = get_theme_mod('home_services_promotion_tags');
			            if(!empty($seviceTag)) {
						    $home_service_promotion_args = array(
						        'post_type'      => 'abt_promotion',
						        'post_status'    => 'publish',
						        'order'          => 'DESC',
						        'posts_per_page'	 => 3,
						        'tax_query'      => [
						            [
						                'taxonomy'   => 'service_tag',
						                'field'      => 'slug',
						                'terms'       => $seviceTag

						            ]
						        ]
						    );
						    $all_posts = get_posts( $home_service_promotion_args );
						}
						
						if(empty($all_posts) || empty($seviceTag)){
							$additionl_args = array(
						        'post_type'				=> 'abt_promotion',
						  		'post_status'    => 'publish',
						        'ignore_sticky_posts'   => true,
						        'order'					=> 'DESC',
						        'posts_per_page'	 		=> 3,
						    );
						    $final_posts = new WP_Query( $additionl_args );
						}else{
							$final_posts = new WP_Query( $home_service_promotion_args );
						}   
		                if ( $final_posts->have_posts() ) :
		                while( $final_posts->have_posts() ):$final_posts->the_post();
		                $custom = get_post_custom(get_the_ID());?>
			            <div class="promotion-holder">
		                    <?php if(has_post_thumbnail()){
		                    	$summary_sub_class= 'with-thumbnails';?>
		                    	<div class="img-holder">
			                       <?php $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');?>
			                    		<img width="465" height="371" src="<?php echo esc_url($image_url[0]); ?>"
			                        class="attachment-full size-full wp-post-image" alt="" loading="lazy">
		                        </div>
		                    <?php } else{
		                    	$summary_sub_class= 'without-thumbnails';
		                    }?>
			                
			                <div class="summary <?php echo $summary_sub_class;?>">

			                    <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

			                    <?php the_excerpt(); ?>
			                    	<p class="disclaimer"><?php echo esc_html($custom['abt_disclaimer'][0]); ?></p>
			                    	<ul class="term-lists">
                                    
                                    <?php
                                    $promo_tags = get_the_terms( get_the_ID(), 'service_tag' );
                                    if( $promo_tags ){
                                        foreach( $promo_tags as $tag ){
                                           echo '<li><a href="'.get_term_link($tag->slug, 'service_tag').'">'.$tag->name.'</a></li>';
                                        }
                                    } 
                                    ?>
                                </ul>
			                    <a class="btn apply-btn" href="<?php the_permalink(); ?>">
			                    	<?php 
			                    		if(get_theme_mod('promotion_readmore_text')){
			                    			echo esc_html(get_theme_mod('promotion_readmore_text'));
			                    		}else{
			                    			echo __('Read More','home-services');
			                    		}
			                    		
			                    	?>
			                    		
			                    	</a>

			                </div>
			            </div>
			            <?php
							endwhile;
			                wp_reset_postdata();  
			            endif;?>
			        </div>
				</div>
			</div>
		</div><!-- end of promotion-->
	<?php }
}?>