<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package home_services
 */
$custom = get_post_custom(get_the_ID());
$home_services_post_type = get_post_type( $post->ID );
if($home_services_post_type == 'abt_promotion'){
	$thumbnails_class= 'promotion-thumbnails';
}else{
	$thumbnails_class='testimonial-thumbnails';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( has_post_thumbnail() && $home_services_post_type=='abt_promotion') {?>
		    <div class="<?php echo esc_attr($thumbnails_class);?>"><?php the_post_thumbnail(); ?></div>
		<?php } ?>
		<?php if($home_services_post_type =='abt_promotion' ){?>
		<header class="entry-header">
			<a href="<?php echo the_permalink();?>"><?php the_title( '<h3 class="entry-title">', '</h3>' ); ?></a>
		</header><!-- .entry-header -->
	<?php } ?>
	
	<div class="entry-content">
		<?php
		the_excerpt();
		?>
		<?php if ( has_post_thumbnail() && $home_services_post_type=='abt_testimonials') {?>
			<div class="<?php echo esc_attr($thumbnails_class);?>"><?php the_post_thumbnail('thumbnail'); ?></div>
		<?php }?>
		<?php 
		if($home_services_post_type =='abt_promotion' ){?>
			<p class="disclaimer"><?php echo esc_html($custom['abt_disclaimer'][0]); ?></p>
		<?php } ?>
		<?php if($home_services_post_type =='abt_testimonials' ){?>
			<header class="entry-header">
				<?php the_title( '<h3 class="entry-title">', '</h3>' ); ?>
			</header><!-- .entry-header -->
		<?php } ?>
		<?php if($home_services_post_type =='abt_testimonials' ){
				 if ($custom['abt_source'][0]){ ?>
		            <span class="review-source">
		                <a target = "_blank"  href="<?php echo esc_url($custom['abt_source_link'][0]); ?>">
		                    <?php echo esc_html($custom['abt_source'][0]); ?>   
		                </a>
		            </span>
			    <?php }  
			 }?>
		<ul class="term-lists">                   
            <?php
            $promo_tags = get_the_terms( get_the_ID(), 'service_tag' );
            if( $promo_tags ){
                foreach( $promo_tags as $tag ){
                   echo '<li><a href="'.get_term_link($tag->slug, 'service_tag').'">'.$tag->name.'</a></li>';
                }
            } 
            ?>
        </ul>
       <?php if($home_services_post_type =='abt_promotion' ){?>
       		<a class="btn apply-btn" href="<?php the_permalink(); ?>"><?php echo __('Claim Now','home-services');?></a>
       <?php } ?>
	</div><!-- .entry-content -->
</article><!-- #post-<?php the_ID(); ?> -->