<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package home_services
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php// home_services_post_thumbnail(); ?>
	<header class="entry-header">
		<?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>

		<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php
			echo  '<span class="post-meta search-author">';
				home_services_posted_by();
			echo '</span>';
			
                     $archive_year  = get_the_time('Y'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?>
                    <span class="post-meta search-post-date"> <a
                            href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php echo get_the_date(); ?></a>
                    </span>
                    <span class="post-meta search-comment">
                            <?php comments_popup_link( __( 'Leave a comment', 'home-services' ), __( '1 comment', 'home-services' ), __( '% comments', 'home-services' ) ); ?>
                    </span>
                    <?php
                    $categories = get_the_category();
                  if( ! empty( $categories ) ) :
                    foreach ( $categories as $category ) { ?>
                        <span class="post-meta search-categories"><a
                            href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a>
                        </span>
                        <?php }
                 endif; 
                  $tags = get_the_tags($post->ID);
                    if( ! empty( $tags ) ) :
                        foreach ( $tags as $post_tag ) { ?>
                            <span class="post-meta search-tag"><i class="fa fa-tag" aria-hidden="true"></i> <a
                                        href="<?php echo esc_url( get_category_link( $post_tag->term_id ) ); ?>"><?php echo esc_html( $post_tag->name ); ?></a>
                            </span>
                     <?php }
                 endif;
                    ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-summary">
		<?php the_excerpt(); ?>
		<a class="more-btn" href="<?php the_permalink();?>"><?php echo __('Read More','home-services')?></a>
	</div><!-- .entry-summary -->
</article><!-- #post-<?php the_ID(); ?> -->
