<?php
/**
 * Template part for displaying page content in testimonials page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package home_services
 */
if ( home_services_set_pro_active() ) {
$home_services_testimonial_layout = get_theme_mod('testimonial_page_sidebar_layout','testimonial-page-no-sidebar');
if($home_services_testimonial_layout == 'testimonial-page-no-sidebar'){
    $testimonial_list_class = 'col-sm-12';
    $filter_nav_class = '';
}else{
    $testimonial_list_class = 'col-sm-8';
    $filter_nav_class = 'col-sm-4';
}
?>
<div class="testimonial-page">
    <?php if($home_services_testimonial_layout =='testimonial-page-no-sidebar'){?>
        <div class="testimonial-list-header">
            <h2 class="text-center"><?php  the_title();?> </h2>
            <p><?php the_content();?></p>
    </div>
   <?php  } 
    if($home_services_testimonial_layout == 'testimonial-page-no-sidebar' || $home_services_testimonial_layout =='testimonial-page-sidebar-left'){?>
    <div class="tag-list left-sidebar <?php echo esc_attr($filter_nav_class);?>">
       
        <?php if($home_services_testimonial_layout =='testimonial-page-sidebar-left' ){?>
            <h3><?php echo __('Filter By Tags','home-services');?></h3>
        <?php } ?>
        
    <?php
    $testimonial_tag = '';
    $i = 0;
    $portfolio_posts = get_posts( array( 'post_type' => 'abt_testimonials', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
    foreach( $portfolio_posts as $portfolio ){
        $terms = get_the_terms( $portfolio->ID, 'service_tag' );
        if( $terms ){
            foreach( $terms as $term ){
                $i++;
                $testimonial_tag .= $term->term_id;
                $testimonial_tag .= ', ';    
            }
        }
    }
    $term_ids = explode( ', ', $testimonial_tag );
    $term_ids = array_diff( array_unique( $term_ids ), array('') );
    wp_reset_postdata();        
        
        
        $args = array(
            'taxonomy'      => 'service_tag',
            'orderby'       => 'name', 
            'order'         => 'ASC',
        );                
        $terms = get_terms( $args );
        if( $terms ){
        ?>
        <div class="button-group filter-button-group filter-buttons">        
            <button data-filter="*" class="active"><?php esc_html_e( 'All testimonials', 'home-services' ); ?></button>
            <?php
                foreach( $terms as $term ){
                    
                        if( in_array( $term->term_id, $term_ids ) )
                        echo '<button data-filter=".' . esc_attr( $term->term_id . '_testimonials_tags' ) .  '">' . esc_html( $term->name ) . '</button>';
                    
                    
                } 
            }
            ?>
        </div>
        <?php
        if($home_services_testimonial_layout =='testimonial-page-sidebar-left'){
            home_services_testimonial_list_sidebar();
        }
        ?>
    </div>
<?php } ?>
    <?php $masionary_view = get_query_var( 'masionary_view' );?>
    <div class="testimonials-layout-2 <?php echo esc_attr($testimonial_list_class);?>">

        <?php if($home_services_testimonial_layout =='testimonial-page-sidebar-left' || $home_services_testimonial_layout =='testimonial-page-sidebar-right'){?>
            <div class="testimonial-list-header">
               <h2><?php  the_title();?> </h2>
                <p><?php the_content();?></p>
            </div>
        <?php } ?>
        <div class="testimonial-block category-promotiofilter content">
            <?php
                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                global $post;
                $query_args = array(
                    'post_type'             => 'abt_testimonials',
                    'posts_per_page'        => 8,
                    'paged' => $paged
                    );
                    
                    $all_posts = new WP_Query( $query_args );
                    $temp_query = $wp_query;
                    $wp_query = null;
                    $wp_query = $all_posts;
                    if ( $all_posts->have_posts() ) :
                    while( $all_posts->have_posts() ):$all_posts->the_post();
                        $custom = get_post_custom(get_the_ID());
                        
                    
                        $terms = get_the_terms( get_the_ID(), 'service_tag' );
                        $testimonial_tax = '';
                        $i = 0;
                        if( $terms ){
                            foreach( $terms as $term ){
                                $i++;
                                $testimonial_tax .= $term->term_id . '_testimonials_tags';
                
                                if( count( $terms ) > $i ){
                                    $testimonial_tax .= ' ';
                                }
                            }
                        } ?>       
                              
                        
                        <div class="testimonial-holder <?php echo esc_attr( $testimonial_tax ); ?>  text-center">
                            <div class="summary">

                                <?php the_excerpt(); ?>

                                <p class="disclaimer"><?php //echo esc_html($custom['abt_disclaimer'][0]); ?></p>
                                <div class="img-holder">
                                    <?php if(has_post_thumbnail()){
                                        $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');
                                    ?>
                                    <img width="100" height="100" src="<?php echo esc_url($image_url[0]); ?>"
                                        class="attachment-full size-full wp-post-image" alt="" loading="lazy">
                                    <?php } ?>
                                </div>
                             <h3 class="post-title"><?php the_title(); ?></h3>
                                <?php if ($custom['abt_source'][0]){ ?>
                                    <span class="review-source">
                                        <a target = "_blank"  href="<?php echo esc_url($custom['abt_source_link'][0]); ?>">
                                            <?php echo esc_html($custom['abt_source'][0]); ?>   
                                        </a>
                                    </span>
                                <?php }  ?>
                                <ul class="term-lists">
                                    
                                    <?php
                                    $promo_tags = get_the_terms( get_the_ID(), 'service_tag' );
                                    if( $promo_tags ){
                                        foreach( $promo_tags as $tag ){
                                           echo '<li><a href="'.get_term_link($tag->slug, 'service_tag').'">'.$tag->name.'</a></li>';
                                        }
                                    } 
                                    ?>
                                </ul>
                               

                            </div>
                        </div>
                        <?php
                       
                endwhile;?>
                
                <?php wp_reset_postdata();  
                endif;      
            ?>
            
        </div>
        <div class="pagination">
                <?php the_posts_navigation(); ?>
            </div>
        <?php 
            $wp_query = NULL;
            $wp_query = $temp_query;
        ?>
        
    </div>
    <?php if ($home_services_testimonial_layout =='testimonial-page-sidebar-right'){?>
    <div class="tag-list right-sidebar <?php echo esc_attr($filter_nav_class);?>">
       
        <?php if( $home_services_testimonial_layout =='testimonial-page-sidebar-right'){?>
            <h3><?php echo __('Filter By Tags','home-services');?></h3>
        <?php } ?>
        
    <?php
    $testimonial_tag = '';
    $i = 0;
    $portfolio_posts = get_posts( array( 'post_type' => 'abt_testimonials', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
    foreach( $portfolio_posts as $portfolio ){
        $terms = get_the_terms( $portfolio->ID, 'service_tag' );
        if( $terms ){
            foreach( $terms as $term ){
                $i++;
                $testimonial_tag .= $term->term_id;
                $testimonial_tag .= ', ';    
            }
        }
    }
    $term_ids = explode( ', ', $testimonial_tag );
    $term_ids = array_diff( array_unique( $term_ids ), array('') );
    wp_reset_postdata();
        $args = array(
            'taxonomy'      => 'service_tag',
            'orderby'       => 'name', 
            'order'         => 'ASC',
        );                
        $terms = get_terms( $args );
        if( $terms ){
        ?>
        <div class="button-group filter-button-group filter-buttons">        
            <button data-filter="*" class="active"><?php esc_html_e( 'All Testimonials', 'home-services' ); ?></button>
            <?php
                foreach( $terms as $term ){
                    
                        if( in_array( $term->term_id, $term_ids ) )
                        echo '<button data-filter=".' . esc_attr( $term->term_id . '_testimonials_tags' ) .  '">' . esc_html( $term->name ) . '</button>';
                    
                    
                } 
            }
            ?>
        </div>
        <?php home_services_testimonial_list_sidebar();?>
    </div>
<?php } ?>
</div>
<?php } ?>