<?php
/**
 * Template part for displaying page content in promotion page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package home_services
 */
if ( home_services_set_pro_active() ) {
$home_services_promotion_layout = get_theme_mod('promotion_page_sidebar_layout','promotion-page-no-sidebar');
if($home_services_promotion_layout == 'promotion-page-no-sidebar'){
    $promotion_list_class = 'col-sm-12';
    $filter_nav_class = '';
}else{
    $promotion_list_class = 'col-sm-8';
    $filter_nav_class = 'col-sm-4';
}
?>
<div class="promotion-page">
    <?php if($home_services_promotion_layout =='promotion-page-no-sidebar'){?>
        <div class="promotion-list-header">
            <h2 class="text-center"><?php  the_title();?> </h2>
            <p><?php the_content();?></p>
    </div>
   <?php  } 
    if($home_services_promotion_layout == 'promotion-page-no-sidebar' || $home_services_promotion_layout =='promotion-page-sidebar-left'){?>
    <div class="tag-list left-sidebar <?php echo esc_attr($filter_nav_class);?>">
       
        <?php if($home_services_promotion_layout =='promotion-page-sidebar-left' ){?>
            <h3><?php echo __('Filter By Tags','home-services');?></h3>
        <?php } ?>
        
    <?php
    $promotion_tag = '';
    $i = 0;
    $portfolio_posts = get_posts( array( 'post_type' => 'abt_promotion', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
    foreach( $portfolio_posts as $portfolio ){
        $terms = get_the_terms( $portfolio->ID, 'service_tag' );
        if( $terms ){
            foreach( $terms as $term ){
                $i++;
                $promotion_tag .= $term->term_id;
                $promotion_tag .= ', ';    
            }
        }
    }
    $term_ids = explode( ', ', $promotion_tag );
    $term_ids = array_diff( array_unique( $term_ids ), array('') );
    wp_reset_postdata();        
        
        
        $args = array(
            'taxonomy'      => 'service_tag',
            'orderby'       => 'name', 
            'order'         => 'ASC',
        );                
        $terms = get_terms( $args );
        if( $terms ){
        ?>
        <div class="button-group filter-button-group filter-buttons">        
            <button data-filter="*" class="active"><?php esc_html_e( 'All', 'home-services' ); ?></button>
            <?php
                foreach( $terms as $term ){
                    
                        if( in_array( $term->term_id, $term_ids ) )
                        echo '<button data-filter=".' . esc_attr( $term->term_id . '_promotion_tags' ) .  '">' . esc_html( $term->name ) . '</button>';
                    
                    
                } 
            }
            ?>
        </div>
        <?php 
        if($home_services_promotion_layout =='promotion-page-sidebar-left'){
            home_services_promotion_list_sidebar(); 
        }?>
    </div>
<?php } ?>
    <?php $masionary_view = get_query_var( 'masionary_view' );?>
    <div class="promotions-layout-2 <?php echo esc_attr($promotion_list_class);?>">

        <?php if($home_services_promotion_layout =='promotion-page-sidebar-left' || $home_services_promotion_layout =='promotion-page-sidebar-right'){?>
            <div class="promotion-list-header">
                <h2><?php  the_title();?> </h2>
                <p><?php the_content();?></p>
            </div>
        <?php } ?>
        <div class="promotion-block grid-biew category-promotiofilter content">
            <?php
                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                global $post;
                $query_args = array(
                    'post_type'				=> 'abt_promotion',
                    'posts_per_page'        => 12,
                    'paged' => $paged
                    );
                    
                    $all_posts = new WP_Query( $query_args );
                    $temp_query = $wp_query;
                    $wp_query = null;
                    $wp_query = $all_posts;
                    if ( $all_posts->have_posts() ) :
                    while( $all_posts->have_posts() ):$all_posts->the_post();
                        $custom = get_post_custom(get_the_ID());
                        
                    
                        $terms = get_the_terms( get_the_ID(), 'service_tag' );
                        $promotion_tax = '';
                        $i = 0;
                        if( $terms ){
                            foreach( $terms as $term ){
                                $i++;
                                $promotion_tax .= $term->term_id . '_promotion_tags';
                
                                if( count( $terms ) > $i ){
                                    $promotion_tax .= ' ';
                                }
                            }
                        } ?>       
                              
                        
                        <div class="promotion-holder <?php echo esc_attr( $promotion_tax ); ?>">
                            <?php if(has_post_thumbnail()){
                                $summary_class = 'width-thumbnails';?>
                                <div class="img-holder">
                                  <?php  $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');
                                ?>
                                <img width="465" height="371" src="<?php echo esc_url($image_url[0]); ?>"
                                    class="attachment-full size-full wp-post-image" alt="" loading="lazy">
                                 </div>
                                <?php 
                            } else{
                                $summary_class = 'widthout-thumbnails';
                            }?>
                           
                            <div class="summary <?php echo esc_attr($summary_class);?>">

                                <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

                                <?php the_excerpt(); ?>

                                <p class="disclaimer"><?php echo esc_html($custom['abt_disclaimer'][0]); ?></p>
                                <ul class="term-lists">
                                    
                                    <?php
                                    $promo_tags = get_the_terms( get_the_ID(), 'service_tag' );
                                    if( $promo_tags ){
                                        foreach( $promo_tags as $tag ){
                                           echo '<li><a href="'.get_term_link($tag->slug, 'service_tag').'">'.$tag->name.'</a></li>';
                                        }
                                    } 
                                    ?>
                                </ul>
                                <a class="btn apply-btn" href="<?php the_permalink(); ?>">
                                    <?php if(get_theme_mod('promotion_readmore_text')){
                                            echo esc_html(get_theme_mod('promotion_readmore_text'));
                                        }else{
                                            echo __('Read More','home-services');
                                        }
                                    ?>
                                </a>

                            </div>
                        </div>
                        <?php
                       
				endwhile;?>
                
                <?php wp_reset_postdata();  
                endif;		
            ?>
            
        </div>
        <div class="pagination">
                <?php the_posts_navigation(); ?>
            </div>
        <?php 
            $wp_query = NULL;
            $wp_query = $temp_query;
        ?>
        
    </div>
    <?php if ($home_services_promotion_layout =='promotion-page-sidebar-right'){?>
    <div class="tag-list right-sidebar <?php echo esc_attr($filter_nav_class);?>">
       
        <?php if( $home_services_promotion_layout =='promotion-page-sidebar-right'){?>
            <h3><?php echo __('Filter By Tags','home-services');?></h3>
        <?php } ?>
        
    <?php
    $promotion_tag = '';
    $i = 0;
    $portfolio_posts = get_posts( array( 'post_type' => 'abt_promotion', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
    foreach( $portfolio_posts as $portfolio ){
        $terms = get_the_terms( $portfolio->ID, 'service_tag' );
        if( $terms ){
            foreach( $terms as $term ){
                $i++;
                $promotion_tag .= $term->term_id;
                $promotion_tag .= ', ';    
            }
        }
    }
    $term_ids = explode( ', ', $promotion_tag );
    $term_ids = array_diff( array_unique( $term_ids ), array('') );
    wp_reset_postdata();
        $args = array(
            'taxonomy'      => 'service_tag',
            'orderby'       => 'name', 
            'order'         => 'ASC',
        );                
        $terms = get_terms( $args );
        if( $terms ){
        ?>
        <div class="button-group filter-button-group filter-buttons">        
            <button data-filter="*" class="active"><?php esc_html_e( 'All', 'home-services' ); ?></button>
            <?php
                foreach( $terms as $term ){
                    
                        if( in_array( $term->term_id, $term_ids ) )
                        echo '<button data-filter=".' . esc_attr( $term->term_id . '_promotion_tags' ) .  '">' . esc_html( $term->name ) . '</button>';
                    
                    
                } 
            }
            ?>
        </div>
        <?php home_services_promotion_list_sidebar(); ?>
    </div>
<?php } ?>
</div>

<?php } ?>