<?php
/**
 * Taxonomy template for promotions
 *
 * @package home_services
 */
get_header();
$home_services_post_type = get_post_type( $post->ID );
if($home_services_post_type == 'abt_promotion'){
	$tax_page_class= 'promotion-tag';
	$main_content_class= 'grid-view';
}else{
	$tax_page_class='testimonials-tag';
	$main_content_class= 'list-view';
}
?>


<div class="inside-page services-tag-page content-area <?php echo esc_attr($tax_page_class);?>">
	
	<div class="container">
		<div class="main-content" id="main-content primary">
			<div class="row"> 
				<div class="tag-header col-sm-12">
					<?php echo '<h2 class="page-title">' . single_cat_title( '', false ) . '</h2>'; ?>
				</div>
				<div class="col-sm-8 <?php echo esc_attr($main_content_class); ?>">
					 <?php

					  while ( have_posts() ) : the_post(); ?>
                            <?php

                            /*
                             * Include the Post-Format-specific template for the content.
                             * If you want to override this in a child theme, then include a file
                             * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                             */
                            get_template_part( 'template-parts/content-tag','servicetag' );
                            ?>
                        <?php endwhile; ?>
                        <?php the_posts_navigation(); ?>

                <?php wp_reset_postdata(); ?>
				</div>
				<div class="col-sm-4 tag-sidebar">
					<?php if($home_services_post_type=='abt_promotion'){
						home_services_promotion_list_sidebar();
					}else{
						home_services_testimonial_list_sidebar();
					}
					?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php 
get_footer();