<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package home_services
 */

get_header();
?>

<?php
	$col_class = 'col-sm-12';
	if( is_active_sidebar( 'sidebar-1' ) ) {
		$col_class = "col-sm-8";
	}
?>
<div class="inside-page search-page">
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( $col_class ); ?>">
				<main id="primary" class="site-main">
					<header class="page-header">
						<h1 class="page-title">
							<?php
							/* translators: %s: search query. */
							printf( esc_html__( 'Search Results for: %s', 'home-services' ), '<span>' . get_search_query() . '</span>' );
							?>
						</h1>
					</header><!-- .page-header -->
					<p><?php get_Search_form(); ?></p>
					<?php if ( have_posts() ) : ?>

					

					<?php
						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

						/**
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */
						get_template_part( 'template-parts/content', 'search' );

					endwhile;

						the_posts_navigation();

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>

				</main><!-- #main -->
			</div>
			<?php if( is_active_sidebar( 'sidebar-1' ) ) { ?>
				<div class="col-sm-4"><?php get_sidebar(); ?></div>
			<?php } ?>
		</div>
	</div>
</div>

<?php
get_footer();
