<?php
/**
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
get_template_part('/inc/tgmpa/class-tgm-plugin', 'activation');

add_action('tgmpa_register', 'home_services_register_required_plugins');

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function home_services_register_required_plugins()
{
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        // This is an example of how to include a plugin bundled with a theme.
        /*array(
            'name' => esc_html__('Elementor', 'home-services'),
            'slug' => 'elementor',
            'required' => false,
        ),*/
        array(
            'name' => esc_html__('Advanced Import', 'home-services'),
            'slug' => 'advanced-import',
            'required' => false,
        ),

        /*array(
            'name' => esc_html__('Alley Elementor Widget', 'home-services'),
            'slug' => 'alley-elementor-widget',
            'required' => false,
        ),*/

        array(
            'name' => esc_html__('Contact Form 7', 'home-services'),
            'slug' => 'contact-form-7',
            'required' => false,
        )

    );
    if (!function_exists('is_plugin_active')) {
        require_once(ABSPATH . '/wp-admin/includes/plugin.php');
    }
    $abt_path_url = WP_PLUGIN_DIR . '/alley-business-toolkit-pro/alley-business-toolkit.php';
    $is_abt_installed = file_exists($abt_path_url);
    $plugins_list_2 = array();
    if (!$is_abt_installed) {
        $plugins_list_2 = array(
            array(
                'name' => esc_html__('Alley Business Toolkit', 'home-services'),
                'slug' => 'alley-business-toolkit',
                'required' => false,
            ),
        );
    } else {
        if (!is_plugin_active('alley-business-toolkit-pro/alley-business-toolkit.php')) {
            $plugins_list_2 = array(
                array(
                    'name' => esc_html__('Alley Business Toolkit Pro', 'home-services'),
                    'slug' => 'alley-business-toolkit-pro',
                    'required' => false,
                ),
            );
        }
    }

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
        'id' => 'home-services',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu' => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug' => 'themes.php',            // Parent menu slug.
        'capability' => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices' => true,                    // Show admin notices or not.
        'dismissable' => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg' => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message' => '',                      // Message to output right before the plugins table.
    );

    tgmpa(array_merge($plugins, $plugins_list_2), $config);
}
