<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package home_services
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function home_services_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	$is_sticky = get_theme_mod( 'home_services_header_sticky_menu_option', false );
	
	if( $is_sticky )
		$classes[] = 'sticky';

	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'home_services_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function home_services_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'home_services_pingback_header' );
if(!function_exists('home_services_promotion_list_sidebar')){
	function home_services_promotion_list_sidebar(){
		if ( is_active_sidebar( 'promotion-sidebar' ) ) : ?>
		    <div id="promotion-sidebar-inner">
		    	<aside id="secondary" class="widget-area cpt-sidebar">
		        	<?php dynamic_sidebar( 'promotion-sidebar' ); ?>
		        </aside>
		    </div>
		<?php endif; 
	}
}
if(!function_exists('home_services_promotion_single_sidebar')){
	function home_services_promotion_single_sidebar(){
		if ( is_active_sidebar( 'promotion-sidebar1' ) ) : ?>
		    <div id="promotion-sidebar-inner">
		    	<aside id="secondary" class="widget-area cpt-sidebar">
		        	<?php dynamic_sidebar( 'promotion-sidebar1' ); ?>
		        </aside>
		    </div>
		<?php endif; 
	}
}
if(!function_exists('home_services_testimonial_list_sidebar')){
	function home_services_testimonial_list_sidebar(){
		if ( is_active_sidebar( 'testimonial-sidebar' ) ) : ?>
		    <div id="promotion-sidebar-inner">
		    	<aside id="secondary" class="widget-area cpt-sidebar">
		        	<?php dynamic_sidebar( 'testimonial-sidebar' ); ?>
		        </aside>
		    </div>
		<?php endif;
	}
}

if(!function_exists('home_services_team_list_sidebar')){
	function home_services_team_list_sidebar(){
		if ( is_active_sidebar( 'team-sidebar' ) ) : ?>
		    <div id="team-sidebar-inner">
		    	<aside id="secondary" class="widget-area cpt-sidebar">
		        	<?php dynamic_sidebar( 'team-sidebar' ); ?>
		        </aside>
		    </div>
		<?php endif;
	}
}
if(!function_exists('home_services_team_page_sidebar')){
	function home_services_team_page_sidebar(){
		if ( is_active_sidebar( 'team-sidebar1' ) ) : ?>
		    <div id="team-sidebar-inner">
		    	<aside id="secondary" class="widget-area cpt-sidebar">
		        	<?php dynamic_sidebar( 'team-sidebar1' ); ?>
		        </aside>
		    </div>
		<?php endif;
	}
}
if( !function_exists('home_services_pagination')):
function home_services_pagination($pages = '', $range = 2){  
	$showitem = ($range * 2)+1;  
	global $paged;
	if(empty($paged)) $paged = 1;
	if($pages == ''){
		global $wp_query;
		$pages = $wp_query->max_num_pages;
		if(!$pages){
		 $pages = 1;
		}
	}   

     if(1 != $pages){
         echo "<div class='home-services-pagination'>";
         if($paged > 1 && $showitem < $pages) echo "<a class='prev' href='".get_pagenum_link($paged - 1)."'><i class='fas fa-chevron-left'></i></a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitem ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' >".$i."</a>";
             }
         }

         if ($paged < $pages && $showitem < $pages) echo "<a class='next' href='".get_pagenum_link($paged + 1)."'><i class='fas fa-chevron-right'></i></a>";  
         echo "</div>\n";
     }
	}
endif;

