<?php

/**
 * Form style for Conatct Form 7
 *
 * @package home_services
 */
add_action( 'customize_register', 'home_services_customize_cpt_team' );

function home_services_customize_cpt_team( $wp_customize ) {
    if ( home_services_set_pro_active() ) {
        $wp_customize->add_panel( 'home_service_cpt_panel', 
            array(
                'priority'       => 25,
                'capability'     => 'edit_theme_options',
                'title'      =>  esc_html__('Custom Post Type Settings', 'home-services'),
            ) 
        );
        /*Team Settings*/
        $wp_customize->add_section( 'home_services_cpt_team_option', array(
            'title'          => esc_html__( 'Teams Options', 'home-services' ),
            'description'    => '', 
            'priority'       => 21,
            'panel'          => 'home_service_cpt_panel',  
        ) );

        $wp_customize->add_setting( 'home_services_team_list_page_option', 
            array(
                'default' => '',
                'type' => 'home-services-customtext',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 
            new Home_Services_Custom_Text( $wp_customize, 'home_services_team_list_page_option', 
                array(
                    'label' => esc_html__( 'Team List Page Settings :', 'home-services' ),
                    'section' => 'home_services_cpt_team_option',
                    'settings' => 'home_services_team_list_page_option',
                ) 
            ) 
        );

        $wp_customize->add_setting( 'team_page_sidebar_layout', 
            array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'team-page-sidebar-right',
            ) 
        );
    
        $wp_customize->add_control( 
            new Home_Services_Radio_Image_Control( $wp_customize, 'team_page_sidebar_layout', 
                array(
                    'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                    'section' => 'home_services_cpt_team_option',
                    'settings' => 'team_page_sidebar_layout',
                    'type'=> 'home-services-radio-image',
                    'choices'     => array(
                        'team-page-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Layout.png',
                        'team-page-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Layout.png',
                        'team-page-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Layout.png',            
                    ),
                ) 
            ) 
        );
        /*Team details page*/
        $wp_customize->add_setting( 'home_services_team_details_page_option', 
            array(
                'default' => '',
                'type' => 'home-services-customtext',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 
            new Home_Services_Custom_Text( $wp_customize, 'home_services_team_details_page_option', 
                array(
                    'label' => esc_html__( 'Single Team Page Settings :', 'home-services' ),
                    'section' => 'home_services_cpt_team_option',
                    'settings' => 'home_services_team_details_page_option',
                ) 
            ) 
        );

        $wp_customize->add_setting( 'single_team_page_sidebar_layout', 
            array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'single-team-page-sidebar-right',
            ) 
        );
    
        $wp_customize->add_control( 
            new Home_Services_Radio_Image_Control( $wp_customize, 'single_team_page_sidebar_layout', 
                array(
                    'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                    'section' => 'home_services_cpt_team_option',
                    'settings' => 'single_team_page_sidebar_layout',
                    'type'=> 'home-services-radio-image',
                    'choices'     => array(
                        'single-team-page-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Blog-Layout.png',
                        'single-team-page-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Blog-Layout.png',
                        'single-team-page-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Blog-Layout.png',            
                    ),
                ) 
            ) 
        );


        /*Promotion  listing/Archive*/
        $wp_customize->add_section( 'home_services_cpt_promotion_option', array(
            'title'          => esc_html__( 'Promotion Options', 'home-services' ),
            'description'    => '', 
            'priority'       => 22,
            'panel'          => 'home_service_cpt_panel',  
        ) );
        
        $wp_customize->add_setting( 'home_services_promotion_list_page_option', 
            array(
                'default' => '',
                'type' => 'home-services-customtext',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 
            new Home_Services_Custom_Text( $wp_customize, 'home_services_promotion_list_page_option', 
                array(
                    'label' => esc_html__( 'Promotion List Page Settings :', 'home-services' ),
                    'section' => 'home_services_cpt_promotion_option',
                    'settings' => 'home_services_promotion_list_page_option',
                ) 
            ) 
        );
        $wp_customize->add_setting( 'promotion_page_sidebar_layout', 
            array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'promotion-page-no-sidebar',
            ) 
        );
    
        $wp_customize->add_control( 
            new Home_Services_Radio_Image_Control( $wp_customize, 'promotion_page_sidebar_layout', 
                array(
                    'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                    'section' => 'home_services_cpt_promotion_option',
                    'settings' => 'promotion_page_sidebar_layout',
                    'type'=> 'home-services-radio-image',
                    'choices'     => array(
                        'promotion-page-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Layout.png',
                        'promotion-page-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Layout.png',
                        'promotion-page-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Layout.png',            
                    ),
                ) 
            ) 
        );
        $wp_customize->add_setting( 'promotion_readmore_text', 
            array(
               
                'default'               =>  '',
                'sanitize_callback'     =>  'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 'promotion_readmore_text', 
            array(
                'label' => esc_html__( 'Read More Label', 'home-services' ),
                'description'=>esc_html__('Read more text to be shown in individual promotion item.','home-services'),
                'section' => 'home_services_cpt_promotion_option',
                'settings' => 'promotion_readmore_text',
                'type'=> 'text',
                'active_callback' => function(){
                    return get_theme_mod( 'promotion_show_hide', true );
                },
            ) 
        );
        /*Promotion details page*/
        $wp_customize->add_setting( 'home_services_promotion_details_page_option', 
            array(
                'default' => '',
                'type' => 'home-services-customtext',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 
            new Home_Services_Custom_Text( $wp_customize, 'home_services_promotion_details_page_option', 
                array(
                    'label' => esc_html__( 'Single Promotion Page Settings :', 'home-services' ),
                    'section' => 'home_services_cpt_promotion_option',
                    'settings' => 'home_services_promotion_details_page_option',
                ) 
            ) 
        );

        $wp_customize->add_setting( 'single_promotion_page_sidebar_layout', 
            array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'single-promotion-page-sidebar-right',
            ) 
        );
    
        $wp_customize->add_control( 
            new Home_Services_Radio_Image_Control( $wp_customize, 'single_promotion_page_sidebar_layout', 
                array(
                    'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                    'section' => 'home_services_cpt_promotion_option',
                    'settings' => 'single_promotion_page_sidebar_layout',
                    'type'=> 'home-services-radio-image',
                    'choices'     => array(
                        'single-promotion-page-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Blog-Layout.png',
                        'single-promotion-page-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Blog-Layout.png',
                        'single-promotion-page-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Blog-Layout.png',            
                    ),
                ) 
            ) 
        );


        /*Testimonial  listing/Archive*/
        $wp_customize->add_section( 'home_services_cpt_testimonial_option', array(
            'title'          => esc_html__( 'Testimonial Options', 'home-services' ),
            'description'    => '', 
            'priority'       => 22,
            'panel'          => 'home_service_cpt_panel',  
        ) );
        
        $wp_customize->add_setting( 'home_services_testimonial_list_page_option', 
            array(
                'default' => '',
                'type' => 'home-services-customtext',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ) 
        );

        $wp_customize->add_control( 
            new Home_Services_Custom_Text( $wp_customize, 'home_services_testimonial_list_page_option', 
                array(
                    'label' => esc_html__( 'Testimonial List Page Settings :', 'home-services' ),
                    'section' => 'home_services_cpt_testimonial_option',
                    'settings' => 'home_services_testimonial_list_page_option',
                ) 
            ) 
        );
        $wp_customize->add_setting( 'testimonial_page_sidebar_layout', 
            array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'testimonial-page-no-sidebar',
            ) 
        );
    
        $wp_customize->add_control( 
            new Home_Services_Radio_Image_Control( $wp_customize, 'testimonial_page_sidebar_layout', 
                array(
                    'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                    'section' => 'home_services_cpt_testimonial_option',
                    'settings' => 'testimonial_page_sidebar_layout',
                    'type'=> 'home-services-radio-image',
                    'choices'     => array(
                        'testimonial-page-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Layout.png',
                        'testimonial-page-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Layout.png',
                        'testimonial-page-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Layout.png',            
                    ),
                ) 
            ) 
        );
   
   
    }
}

