<?php
/**
 * Color and Fonts options
 */

add_action( 'customize_register', 'home_services_colors_panel' );

function home_services_colors_panel( $wp_customize)  {
    $wp_customize->get_section( 'colors' )->priority = 11;
    $wp_customize->get_section( 'colors' )->title  = esc_html__('Color', 'home-services' );
    $wp_customize->get_section( 'colors' )->panel = "home_service_appearance_settings";
}

add_action( 'customize_register', 'home_services_color_fonts_options_section' );

function home_services_color_fonts_options_section( $wp_customize ) {
    $wp_customize->add_section( 'home_services_fonts_settings', array(
        'title'          => esc_html__( 'Fonts', 'home-services' ),
        'priority'       => 12,
        'panel'          => 'home_service_appearance_settings',
    ) );

    $wp_customize->add_setting( 'body_options_text', array(
        'default' => '',
        'type' => 'home-services-customtext',
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( new Home_Services_Custom_Text( $wp_customize, 'body_options_text', array(
        'label' => esc_html__( 'Body Options', 'home-services' ),
        'section' => 'home_services_fonts_settings',
        'settings' => 'body_options_text',
        'priority' => 90,
    ) ) );

    $wp_customize->add_setting( 'body_line_height', array(
        'default'           => 1.5,
        'sanitize_callback' => 'home_services_sanitize_float',
        'transport' => 'postMessage',
    ) );

    $wp_customize->add_control( new Home_Services_Slider_Control( $wp_customize, 'body_line_height', array(
        'section' => 'home_services_fonts_settings',
        'settings' => 'body_line_height',
        'label'   => esc_html__( 'Line Height', 'home-services' ),
        'priority' => 96,
        'choices'     => array(
            'min'   => 0.1,
            'max'   => 10,
            'step'  => 0.1,
        )
    ) ) );
    $wp_customize->add_setting( 'font_family', array(
        'transport' => 'postMessage',
        'default'     => 'Quicksand',
        'sanitize_callback' => 'home_services_sanitize_google_fonts',
    ) );

    $wp_customize->add_control( 'font_family', array(
        'settings'    => 'font_family',
        'label'       =>  esc_html__( 'Body Font Family', 'home-services' ),
        'section'     => 'home_services_fonts_settings',
        'type'        => 'select',
        'choices'     => home_services_google_fonts(),
        'priority' => 92,
    ) );

    $wp_customize->add_setting( 'font_size', array(
        'transport' => 'postMessage',
        'default'     => '14px',
        'sanitize_callback' => 'home_services_sanitize_select',
    ) );

    $wp_customize->add_control( 'font_size', array(
        'settings'    => 'font_size',
        'label'       =>  esc_html__( 'Body Font Size', 'home-services' ),
        'section'     => 'home_services_fonts_settings',
        'type'        => 'select',
        'default'     => '13px',
        'choices'     =>  array(
            '13px' => '13px',
            '14px' => '14px',
            '15px' => '15px',
            '16px' => '16px',
            '17px' => '17px',
            '18px' => '18px',
        ),
        'priority'    => 93
    ) );

    $wp_customize->add_setting( 'body_font_weight', array(
        'default'           => 500,
        'sanitize_callback' => 'absint',
        'transport' => 'postMessage',
    ) );

    $wp_customize->add_control( new Home_Services_Slider_Control( $wp_customize, 'body_font_weight', array(
        'section' => 'home_services_fonts_settings',
        'settings' => 'body_font_weight',
        'label'   => esc_html__( 'Font Weight', 'home-services' ),
        'priority' => 94,
        'choices'     => array(
            'min'  => 100,
            'max'  => 900,
            'step' => 100,
        ),
    ) ) );

    $wp_customize->add_setting( 'heading_options_text', array(
        'default' => '',
        'type' => 'home-services-customtext',
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( new Home_Services_Custom_Text( $wp_customize, 'heading_options_text', array(
        'label' => esc_html__( 'Heading Options', 'home-services' ),
        'section' => 'home_services_fonts_settings',
        'settings' => 'heading_options_text',
        'priority'    => 70
    ) ) );

    $wp_customize->add_setting( 'header_line_height', array(
        'default'           => 1.5,
        'sanitize_callback' => 'home_services_sanitize_float',
        'transport' => 'postMessage',
    ) );

    $wp_customize->add_control( new Home_Services_Slider_Control( $wp_customize, 'header_line_height', array(
        'section' => 'home_services_fonts_settings',
        'settings' => 'header_line_height',
        'label'   => esc_html__( 'Line Height', 'home-services' ),
        'priority'    => 78,
        'choices'     => array(
            'min'   => 0.1,
            'max'   => 10,
            'step'  => 0.1,
        )  
    ) ) );

    $wp_customize->add_setting( 'heading_font_family', array(
        'transport' => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_google_fonts',
        'default'     => 'Poppins',
    ) );

    $wp_customize->add_control( 'heading_font_family', array(
        'settings'    => 'heading_font_family',
        'label'       =>  esc_html__( 'Heading Font Family', 'home-services' ),
        'section'     => 'home_services_fonts_settings',
        'type'        => 'select',
        'choices'     => home_services_google_fonts(),
        'priority'    => 72
    ) );

    $wp_customize->add_setting( 'heading_font_weight', array(
        'default'           => 600,
        'sanitize_callback' => 'absint',
        'transport' => 'postMessage',
    ) );

    $wp_customize->add_control( new Home_Services_Slider_Control( $wp_customize, 'heading_font_weight', array(
        'section' => 'home_services_fonts_settings',
        'settings' => 'heading_font_weight',
        'label'   => esc_html__( 'Font Weight', 'home-services' ),
        'priority' => 77,
        'choices'     => array(
            'min'  => 100,
            'max'  => 900,
            'step' => 100,
        ),
    ) ) );

    $default_size = array(
        '1' =>  32,
        '2' =>  28,
        '3' =>  24,
        '4' =>  21,
        '5' =>  15,
        '6' =>  12,
    );

    for( $i = 1; $i <= 6 ; $i++ ) {

        $max_size = $i == '1'? '150' : '50';
        $wp_customize->add_setting( 'home_services_heading_' . $i . '_size', array(
            'default'           => $default_size[$i],
            'sanitize_callback' => 'absint',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control( 'home_services_heading_' . $i . '_size', array(
            'type'  => 'number',
            'section'   => 'home_services_fonts_settings',
            'label' => esc_html__( 'Heading ', 'home-services' ) . $i . esc_html__(' Size', 'home-services' ),
            'priority' => 74,
            'input_attrs' => array(
                'min' => 10,
                'max' => $max_size,
                'step'  =>  1
            ),
        ) );
    }

    $wp_customize->add_setting( 'primary_color', array(
        'default'     => '#05398e',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'primary_color', array(
        'label'      => esc_html__( 'Primary Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'primary_color',
        'priority'   => 1
    ) ) );

    $wp_customize->add_setting( 'secondary_color', array(
        'default'     => '#faaa29',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'secondary_color', array(
        'label'      => esc_html__( 'Secondary Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'secondary_color',
        'priority'   => 1
    ) ) );
            
    $wp_customize->add_setting( 'text_color', array(
        'default'     => '#010101',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_color', array(
        'label'      => esc_html__( 'Text Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'text_color',
        'priority'   => 1
    ) ) );

    $wp_customize->add_setting( 'accent_color', array(
        'default'     => '#05398e',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'accent_color', array(
        'label'      => esc_html__( 'Accent Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'accent_color',
        'priority'   => 1
    ) ) );

    $wp_customize->add_setting( 'light_color', array(
        'default'     => '#ffffff',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'light_color', array(
        'label'      => esc_html__( 'Light Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'light_color',
        'priority'   => 1
    ) ) );

    $wp_customize->add_setting( 'dark_color', array(
        'default'     => '#010101',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'dark_color', array(
        'label'      => esc_html__( 'Dark Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'dark_color',
        'priority'   => 1
    ) ) );

    $wp_customize->add_setting( 'grey_color', array(
        'default'     => '#aaaaaa ',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'grey_color', array(
        'label'      => esc_html__( 'Grey Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'grey_color',
        'priority'   => 1
    ) ) );
    $wp_customize->add_setting( 'link_color', array(
        'default'     => '#05398e',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'home_services_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_color', array(
        'label'      => esc_html__( 'Link Color', 'home-services' ),
        'section'    => 'colors',
        'settings'   => 'link_color',
        'priority'   => 1
    ) ) );

    


}

