<?php
/**
 * Template part for displaying slider section
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */

$home_renovation_agency_static_image = get_stylesheet_directory_uri() . '/assets/images/header_img.png';

// Check if slider arrows are enabled
if ( get_theme_mod( 'home_renovation_agency_slider_arrows', true ) ) : ?>

<section id="slider">
  <?php 
  // Get side text for the slider
  $home_renovation_agency_side_text = get_theme_mod( 'home_renovation_agency_slider_side_text', 'Home Renovation' ); 
  if ( ! empty( $home_renovation_agency_side_text ) ) : ?>
    <p class="welcome-text m-0"><?php echo esc_html( $home_renovation_agency_side_text ); ?></p>
  <?php endif; ?>

  <div class="owl-carousel">
    <?php
    $home_renovation_agency_slide_pages = array();
    
    // Loop through 4 possible slides
    for ( $home_renovation_agency_count = 1; $home_renovation_agency_count <= 4; $home_renovation_agency_count++ ) {
        $home_renovation_agency_mod = intval( get_theme_mod( 'home_renovation_agency_slider_page' . $home_renovation_agency_count ) );
        if ( $home_renovation_agency_mod && 'page-none-selected' !== $home_renovation_agency_mod ) {
            $home_renovation_agency_slide_pages[] = $home_renovation_agency_mod;
        }
    }

    // Check if there are any pages for the slider
    if ( ! empty( $home_renovation_agency_slide_pages ) ) :
        $home_renovation_agency_args = array(
            'post_type'      => 'page',
            'post__in'       => $home_renovation_agency_slide_pages,
            'orderby'        => 'post__in',
            'posts_per_page' => 4, // Limit to 4 posts
        );
        $home_renovation_agency_query = new WP_Query( $home_renovation_agency_args );

        if ( $home_renovation_agency_query->have_posts() ) :
            while ( $home_renovation_agency_query->have_posts() ) : $home_renovation_agency_query->the_post(); ?>
                <div class="slide-box">
                    <div class="inner_content">
                        <?php if ( get_theme_mod( 'home_renovation_agency_slider_short_heading' ) ) : ?>
                            <p class="slider-top"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_slider_short_heading' ) ); ?></p>
                        <?php endif; ?>
                        <?php if (get_theme_mod('home_renovation_agency_show_slider_title', true)) : ?>
                          <h1><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h1>
                        <?php endif; ?>
                        <?php if (get_theme_mod('home_renovation_agency_show_slider_content', true)) : ?>
                          <p class="slide-content"><?php $home_renovation_agency_excerpt = get_the_excerpt(); echo esc_html( home_renovation_agency_string_limit_words( $home_renovation_agency_excerpt, esc_attr(get_theme_mod('home_renovation_agency_slider_excerpt_length','50')))); ?></p>
                        <?php endif; ?>
                        <div class="more-btn mt-4">
                            <a class="btn-1" href="<?php echo esc_url( get_permalink() ); ?>" target="_blank">
                                <?php esc_html_e( 'Explore More', 'home-renovation-agency' ); ?>
                            </a>
                        </div>
                    </div>

                    <div class="img-box">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <img src="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>" alt="<?php the_title_attribute(); ?>" />
                        <?php else : ?>
                            <img src="<?php echo esc_url( $home_renovation_agency_static_image ); ?>" alt="<?php esc_attr_e( 'Placeholder', 'home-renovation-agency' ); ?>" />
                        <?php endif; ?>
                    </div>
                </div>

            <?php endwhile;
            wp_reset_postdata();
        else : ?>
            <div class="no-postfound"><?php esc_html_e( 'No slides found', 'home-renovation-agency' ); ?></div>
        <?php endif;
    endif;
    ?>
  </div>

  <!-- New Wrapper for slider-bottom content -->
  <div class="slider-bottom-content">
    <div class="below-slider">
      <div class="container">
        <div class="row">
          <div class="col-lg-7 col-md-6 col-12 align-self-center">
            <!-- Call Info -->
            <div class="contact call">
              <?php if ( get_theme_mod( 'home_renovation_agency_call_text' ) || get_theme_mod( 'home_renovation_agency_call' ) ) : ?>
                <div class="row">
                  <div class="col-lg-1 col-md-2 col-2 align-self-center text-center text-md-start">
                    <i class="fas fa-phone"></i>
                  </div>
                  <div class="col-lg-11 col-md-10 col-10 align-self-center text-start contact-col call px-lg-0">
                    <p class="infotext text-capitalize"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_call_text', '' ) ); ?></p>
                    <p class="mb-0 contact-content">
                      <a href="tel:<?php echo esc_attr( get_theme_mod( 'home_renovation_agency_call', '' ) ); ?>">
                          <?php echo esc_html( get_theme_mod( 'home_renovation_agency_call', '' ) ); ?>
                      </a>
                    </p>
                  </div>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <?php if (get_theme_mod('home_renovation_agency_total_no_award_winning') || get_theme_mod('home_renovation_agency_total_no_project_complete') || get_theme_mod('home_renovation_agency_total_no_happy_client')) : ?>
            <div class="col-lg-5 col-md-6 col-12 total-main align-self-center">
              <div class="row">
                <div class="col-lg-4 col-md-4 col-4">
                  <!-- Award Info -->
                  <?php if ( get_theme_mod( 'home_renovation_agency_total_no_award_winning' ) ) : ?>
                    <div class="award">
                      <div class="award-no no-text"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_total_no_award_winning', '' ) ); ?></div>
                      <div class="award-text no-content"><?php esc_html_e( 'Award Winning', 'home-renovation-agency' ); ?></div>
                    </div>
                  <?php endif; ?>
                </div>
                <div class="col-lg-4 col-md-4 col-4">
                  <!-- Project Info -->
                  <?php if ( get_theme_mod( 'home_renovation_agency_total_no_project_complete' ) ) : ?>
                    <div class="project">
                      <div class="project-no no-text"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_total_no_project_complete', '' ) ); ?></div>
                      <div class="project-text no-content"><?php esc_html_e( 'Project Complete', 'home-renovation-agency' ); ?></div>
                    </div>
                  <?php endif; ?>
                </div>
                <div class="col-lg-4 col-md-4 col-4">
                  <!-- Client Info -->
                  <?php if ( get_theme_mod( 'home_renovation_agency_total_no_happy_client' ) ) : ?>
                    <div class="client">
                      <div class="client-no no-text"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_total_no_happy_client', '' ) ); ?></div>
                      <div class="client-text no-content"><?php esc_html_e( 'Happy Client', 'home-renovation-agency' ); ?></div>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<?php endif; // End of slider check ?>