<?php
/**
 * Template part for displaying the about section
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */

$home_renovation_agency_static_image = get_stylesheet_directory_uri() . '/assets/images/header_img.png';

// Check if the about section is enabled
if ( get_theme_mod( 'home_renovation_agency_about_enable', true ) ) : ?>
<section id="about" class="my-5 px-md-0 px-3">
    <div class="container">
        <?php
        // Fetch about page ID from customizer
        $home_renovation_agency_about_page_id = absint( get_theme_mod( 'home_renovation_agency_about_page' ) );
        $home_renovation_agency_youtube_url = get_theme_mod( 'home_renovation_agency_youtube_url', '' );
        
        // Check if a valid page is set for about section
        if ( $home_renovation_agency_about_page_id ) : 
            $home_renovation_agency_args = array(
                'post_type' => 'page',
                'p'         => $home_renovation_agency_about_page_id
            );
            $home_renovation_agency_query = new WP_Query( $home_renovation_agency_args );
            
            // Check if the query has posts
            if ( $home_renovation_agency_query->have_posts() ) :
                while ( $home_renovation_agency_query->have_posts() ) : $home_renovation_agency_query->the_post(); ?>
                    <div class="row">
                        <div class="col-lg-5 col-md-5 align-self-center image-abt">
                            <div class="about-block position-relative">
                                <div class="about-image1">
                                    <div class="thumbnail position-relative">
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <?php the_post_thumbnail( 'full' ); ?>
                                        <?php else : ?>
                                            <img src="<?php echo esc_url( $home_renovation_agency_static_image ); ?>" alt="<?php esc_attr_e( 'Placeholder', 'home-renovation-agency' ); ?>" />
                                        <?php endif; ?>
                                        
                                        <?php if ( $home_renovation_agency_youtube_url ) : ?>
                                            <a href="<?php echo esc_url( $home_renovation_agency_youtube_url ); ?>" class="youtube-icon-overlay" target="_blank">
                                                <i class="fas fa-play"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7 col-md-7 align-self-center">
                            <div class="match-heading">
                                <?php if ( get_theme_mod( 'home_renovation_agency_service_sub_heading' ) ) : ?>
                                    <p class="mb-3 abt-title"><?php echo esc_html( get_theme_mod( 'home_renovation_agency_service_sub_heading' ) ); ?></p>
                                <?php endif; ?>
                                <h2 class="mb-2">
                                    <a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a>
                                </h2>
                            </div>
                            <p class="mb-4 abt-content"><?php echo esc_html( wp_trim_words( get_the_content(), 70 ) ); ?></p>

                            <?php if ( get_theme_mod( 'home_renovation_agency_tab_heading1' ) || get_theme_mod( 'home_renovation_agency_tab_heading2' ) ) : ?>
                                <div class="row">
                                    <?php for ( $home_renovation_agency_i = 1; $home_renovation_agency_i <= 2; $home_renovation_agency_i++ ) : ?>
                                        <?php if ( get_theme_mod( 'home_renovation_agency_tab_heading' . $home_renovation_agency_i ) ) : ?>
                                            <div class="col-lg-6 col-md-6"> <!-- Column -->
                                                <div class="tab-details d-flex align-items-center">
                                                    <?php
                                                        // Get the icon class, defaulting to 'fas fa-address-book' if no setting is found
                                                        $home_renovation_agency_icon_class = get_theme_mod('home_renovation_agency_tab_icon' . $home_renovation_agency_i, 'fas fa-address-book');
                                                    ?>

                                                    <?php if ($home_renovation_agency_icon_class) : ?>
                                                        <i class="me-3 <?php echo esc_attr($home_renovation_agency_icon_class); ?>"></i>
                                                    <?php endif; ?>

                                                    <h3><?php echo esc_html( get_theme_mod( 'home_renovation_agency_tab_heading' . $home_renovation_agency_i ) ); ?></h3>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata();
            endif;
        endif; ?>
    </div>
</section>
<?php endif; ?>