<?php
/*
 * Displays the header section with logo, site title, tagline, navigation, and contact information.
 */
?>

<div class="headerbox">
    <div class="container header-main">
        <div class="row m-0">
            <div class="col-lg-3 col-md-4 col-12 logo-col align-self-center">
                <div class="logo text-center text-md-start">
                    <?php if (has_custom_logo()) : ?>
                        <?php the_custom_logo(); ?>
                    <?php endif; ?>

                    <?php if (get_theme_mod('home_renovation_agency_site_title', 1)) : ?>
                        <?php if (is_front_page() && is_home()) : ?>
                            <p class="text-capitalize mb-0">
                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                            </p>
                        <?php else : ?>
                            <h1 class="text-capitalize">
                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                            </h1>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php
                    $home_renovation_agency_description = get_bloginfo('description', 'display');
                    if ($home_renovation_agency_description || is_customize_preview()) :
                        if (get_theme_mod('home_renovation_agency_site_tagline', 0)) :
                            ?>
                            <p class="site-description my-1 text-capitalize"><?php echo esc_html($home_renovation_agency_description); ?></p>
                        <?php endif; 
                    endif;
                    ?>
                </div>
            </div>

            <div class="col-lg-6 col-md-4 col-12 align-self-center">
                <div class="main-navhead">
                    <div class="menubox">
                        <div class="menu-content">
                            <?php
                            // Include the navigation template part
                            get_template_part('template-parts/navigation/site-nav');
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-4 col-12 align-self-center text-center px-md-4 text-md-end align-items-center">
                <span class="search-bar">
                    <button type="button" class="open-search"><i class="fas fa-search"></i></button>
                </span>

                <?php if (get_theme_mod('home_renovation_agency_header_link') || get_theme_mod('home_renovation_agency_header_button', 'Get Start')) : ?>
                    <span class="header-btn">
                        <a href="<?php echo esc_url(get_theme_mod('home_renovation_agency_header_link')); ?>" class="book-appoin"><?php echo esc_html(get_theme_mod('home_renovation_agency_header_button', 'Get Start')); ?></a>
                    </span>
                <?php endif; ?>
            </div>

            <div class="search-outer">
                <div class="inner_searchbox w-100 h-100">
                    <?php get_search_form(); ?>
                </div>
                <button type="button" class="search-close"><?php esc_html_e('CLOSE', 'home-renovation-agency'); ?></button>
            </div>
        </div>
    </div>
</div>