<?php
/**
 * Displays footer widgets if assigned
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */

?>
<?php

// Determine the number of columns dynamically for the footer (you can replace this with your logic).
$home_renovation_agency_no_of_footer_col = get_theme_mod('home_renovation_agency_footer_columns', 4); // Change this value as needed.

// Calculate the Bootstrap class for large screens (col-lg-X) for footer.
$home_renovation_agency_col_lg_footer_class = 'col-lg-' . (12 / $home_renovation_agency_no_of_footer_col);

// Calculate the Bootstrap class for medium screens (col-md-X) for footer.
$home_renovation_agency_col_md_footer_class = 'col-md-' . (12 / $home_renovation_agency_no_of_footer_col);
?>
<div class="container">
    <aside class="widget-area row py-2 pt-3" role="complementary" aria-label="<?php esc_attr_e( 'Footer', 'home-renovation-agency' ); ?>">
        <?php
        $home_renovation_agency_default_widgets = array(
            1 => 'search',
            2 => 'archives',
            3 => 'meta',
            4 => 'categories'
        );

        for ($home_renovation_agency_i = 1; $home_renovation_agency_i <= $home_renovation_agency_no_of_footer_col; $home_renovation_agency_i++) :
            $home_renovation_agency_lg_class = esc_attr($home_renovation_agency_col_lg_footer_class);
            $home_renovation_agency_md_class = esc_attr($home_renovation_agency_col_md_footer_class);
            echo '<div class="col-12 ' . $home_renovation_agency_lg_class . ' ' . $home_renovation_agency_md_class . '">';

            if (is_active_sidebar('footer-' . $home_renovation_agency_i)) {
                dynamic_sidebar('footer-' . $home_renovation_agency_i);
            } else {
                // Display default widget content if not active.
                switch ($home_renovation_agency_default_widgets[$home_renovation_agency_i] ?? '') {
                    case 'search':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Search', 'home-renovation-agency'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Search', 'home-renovation-agency'); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                        <?php
                        break;

                    case 'archives':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Archives', 'home-renovation-agency'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Archives', 'home-renovation-agency'); ?></h3>
                            <ul><?php wp_get_archives(['type' => 'monthly']); ?></ul>
                        </aside>
                        <?php
                        break;

                    case 'meta':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Meta', 'home-renovation-agency'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Meta', 'home-renovation-agency'); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                        <?php
                        break;

                    case 'categories':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Categories', 'home-renovation-agency'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Categories', 'home-renovation-agency'); ?></h3>
                            <ul><?php wp_list_categories(['title_li' => '']); ?></ul>
                        </aside>
                        <?php
                        break;
                }
            }

            echo '</div>';
        endfor;
        ?>
    </aside>
</div>