<?php
/**
 * Template for displaying search forms in Home Renovation Agency
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */
?>

<?php $home_renovation_agency_unique_id = esc_attr( uniqid( 'search-form-' ) ); ?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">	
	<input type="search" id="<?php echo esc_attr( $home_renovation_agency_unique_id ); ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'home-renovation-agency' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	<button type="submit" class="search-submit"><?php echo esc_html_x( 'Search', 'submit button', 'home-renovation-agency' ); ?></button>
</form>