<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

    
    function home_renovation_agency_import_demo_content() {
        
        // Display the preloader only for plugin installation
        echo '<div id="plugin-loader" style="display: flex; align-items: center; justify-content: center; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.8); z-index: 9999;">
                <img src="' . esc_url(get_template_directory_uri()) . '/assets/images/loader.png" alt="Loading..." width="60" height="60" />
              </div>';

        // Define the plugins you want to install and activate
        $plugins = array(
            array(
                'slug' => 'advanced-appointment-booking-scheduling',
                'file' => 'advanced-appointment-booking-scheduling/advanced-appointment-booking.php',
                'url'  => 'https://downloads.wordpress.org/plugin/advanced-appointment-booking-scheduling.zip'
            ),
        );

        // Include required files for plugin installation
        include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
        include_once(ABSPATH . 'wp-admin/includes/file.php');
        include_once(ABSPATH . 'wp-admin/includes/misc.php');
        include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

        // Loop through each plugin
        foreach ($plugins as $plugin) {
            $plugin_file = WP_PLUGIN_DIR . '/' . $plugin['file'];

            // Check if the plugin is installed
            if (!file_exists($plugin_file)) {
                // If the plugin is not installed, download and install it
                $upgrader = new Plugin_Upgrader();
                $result = $upgrader->install($plugin['url']);

                // Check for installation errors
                if (is_wp_error($result)) {
                    error_log('Plugin installation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                    echo 'Error installing plugin: ' . esc_html($plugin['slug']) . ' - ' . esc_html($result->get_error_message());
                    continue;
                }
            }

            // If the plugin exists but is not active, activate it
            if (file_exists($plugin_file) && !is_plugin_active($plugin['file'])) {
                $result = activate_plugin($plugin['file']);

                // Check for activation errors
                if (is_wp_error($result)) {
                    error_log('Plugin activation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                    echo 'Error activating plugin: ' . esc_html($plugin['slug']) . ' - ' . esc_html($result->get_error_message());
                }
            }
        }

        // Hide the preloader after the process is complete
        echo '<script type="text/javascript">
                document.getElementById("plugin-loader").style.display = "none";
              </script>';

        // Add filter to skip WooCommerce setup wizard after activation
        add_filter('woocommerce_prevent_automatic_wizard_redirect', '__return_true');
    }

    // Call the import function
    home_renovation_agency_import_demo_content();


    // ------- Create Nav Menu --------
$home_renovation_agency_menuname = 'Main Menus';
$home_renovation_agency_bpmenulocation = 'primary-menu';
$home_renovation_agency_menu_exists = wp_get_nav_menu_object($home_renovation_agency_menuname);

if (!$home_renovation_agency_menu_exists) {
    $home_renovation_agency_menu_id = wp_create_nav_menu($home_renovation_agency_menuname);

    // Create Home Page
    $home_renovation_agency_home_title = 'Home';
    $home_renovation_agency_home = array(
        'post_type' => 'page',
        'post_title' => $home_renovation_agency_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $home_renovation_agency_home_id = wp_insert_post($home_renovation_agency_home);

    // Assign Home Page Template
    add_post_meta($home_renovation_agency_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $home_renovation_agency_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($home_renovation_agency_menu_id, 0, array(
        'menu-item-title' => __('Home', 'home-renovation-agency'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $home_renovation_agency_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $home_renovation_agency_about_title = 'About Us';
    $home_renovation_agency_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $home_renovation_agency_about = array(
        'post_type' => 'page',
        'post_title' => $home_renovation_agency_about_title,
        'post_content' => $home_renovation_agency_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $home_renovation_agency_about_id = wp_insert_post($home_renovation_agency_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($home_renovation_agency_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'home-renovation-agency'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $home_renovation_agency_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $home_renovation_agency_services_title = 'Services';
    $home_renovation_agency_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $home_renovation_agency_services = array(
        'post_type' => 'page',
        'post_title' => $home_renovation_agency_services_title,
        'post_content' => $home_renovation_agency_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $home_renovation_agency_services_id = wp_insert_post($home_renovation_agency_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($home_renovation_agency_menu_id, 0, array(
        'menu-item-title' => __('Services', 'home-renovation-agency'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $home_renovation_agency_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $home_renovation_agency_pages_title = 'Pages';
    $home_renovation_agency_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $home_renovation_agency_pages = array(
        'post_type' => 'page',
        'post_title' => $home_renovation_agency_pages_title,
        'post_content' => $home_renovation_agency_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $home_renovation_agency_pages_id = wp_insert_post($home_renovation_agency_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($home_renovation_agency_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'home-renovation-agency'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $home_renovation_agency_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $home_renovation_agency_contact_title = 'Contact';
    $home_renovation_agency_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $home_renovation_agency_contact = array(
        'post_type' => 'page',
        'post_title' => $home_renovation_agency_contact_title,
        'post_content' => $home_renovation_agency_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $home_renovation_agency_contact_id = wp_insert_post($home_renovation_agency_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($home_renovation_agency_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'home-renovation-agency'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $home_renovation_agency_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($home_renovation_agency_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$home_renovation_agency_bpmenulocation] = $home_renovation_agency_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('home_renovation_agency_header_button', 'Get Start');
        set_theme_mod('home_renovation_agency_header_link', '#');

        // Slider Section
        set_theme_mod('home_renovation_agency_slider_arrows', true);
        set_theme_mod('home_renovation_agency_slider_side_text', 'Home Renovation' );
        set_theme_mod('home_renovation_agency_slider_short_heading', 'Welcome To Home Renovation');

        set_theme_mod('home_renovation_agency_call_text', 'Hot Line 24/7');
        set_theme_mod('home_renovation_agency_call', '+12 1234567890');
        set_theme_mod('home_renovation_agency_total_no_award_winning', '25+');
        set_theme_mod('home_renovation_agency_total_no_project_complete', '960+');
        set_theme_mod('home_renovation_agency_total_no_happy_client', '95%');

        for ($i = 1; $i <= 4; $i++) {
            $home_renovation_agency_title = 'Personalized Home Renovation Solutions';
            $home_renovation_agency_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($home_renovation_agency_title),
                'post_content'  => $home_renovation_agency_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
            );

            // Insert the post into the database
            $post_id = wp_insert_post($my_post);

            // Check for errors when inserting the post
            if (is_wp_error($post_id)) {
                error_log('Error creating slider page: ' . $post_id->get_error_message());
                continue; // Skip to the next iteration if error occurs
            }

            // Set the theme mod for the slider page
            set_theme_mod('home_renovation_agency_slider_page' . $i, $post_id);

            // Set the slider image
            $image_url = get_template_directory_uri() . '/assets/images/slider.png';
            $image_id = media_sideload_image($image_url, $post_id, null, 'id');

            // Handle image download errors
            if (!is_wp_error($image_id)) {
                // Set the downloaded image as the post's featured image
                set_post_thumbnail($post_id, $image_id);
            } else {
                error_log('Error downloading slider image: ' . $image_id->get_error_message());
            }
        }


        // About Section
        set_theme_mod('home_renovation_agency_about_enable', true);
        set_theme_mod('home_renovation_agency_service_sub_heading', 'Why Should CHoose Us');
        set_theme_mod('home_renovation_agency_youtube_url', '#');


        set_theme_mod('home_renovation_agency_tab_icon1', 'fas fa-address-book');
        set_theme_mod('home_renovation_agency_tab_icon2', 'fas fa-address-book');

        set_theme_mod('home_renovation_agency_tab_heading1', 'Quality Standards Products');
        set_theme_mod('home_renovation_agency_tab_heading2', 'Cost Effective Services');

        // Create About page and set the featured image
        $home_renovation_agency_abt_title = 'Offer Reliable Services For Most in Renovation Services';
        $home_renovation_agency_abt_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.Lorem ipsum dolor sit amet, consectetur adipiscing elit,';

        $my_post = array(
            'post_title'    => wp_strip_all_tags($home_renovation_agency_abt_title),
            'post_content'  => $home_renovation_agency_abt_content,
            'post_status'   => 'publish',
            'post_type'     => 'page',
        );

        // Insert the post into the database
        $post_id = wp_insert_post($my_post);

        if ($post_id) {
            // Set the theme mod for the About page
            set_theme_mod('home_renovation_agency_about_page', $post_id);

            // Sideload image and set as the featured image
            $image_url = get_template_directory_uri() . '/assets/images/about-img.png';
            $image_id = media_sideload_image($image_url, $post_id, null, 'id');

            if (!is_wp_error($image_id)) {
                set_post_thumbnail($post_id, $image_id);
            }
        }


    }

?>