<?php
/**
 * Home Renovation Agency: Customizer
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function Home_Renovation_Agency_Customize_register( $wp_customize ) {

	// Pro Version
    class home_renovation_agency_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( HOME_RENOVATION_AGENCY_BUY_TEXT,'home-renovation-agency' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function home_renovation_agency_sanitize_custom_control( $input ) {
        return $input;
    }

	require get_parent_theme_file_path('/inc/controls/icon-changer.php');

	require get_parent_theme_file_path('/inc/controls/range-slider-control.php');

	// Register the custom control type.
	$wp_customize->register_control_type( 'Home_Renovation_Agency_Toggle_Control' );

	//Register the sortable control type.
	$wp_customize->register_control_type( 'Home_Renovation_Agency_Control_Sortable' );	

	//add home page setting pannel
	$wp_customize->add_panel( 'home_renovation_agency_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Custom Home page', 'home-renovation-agency' ),
	    'description' => __( 'Description of what this panel does.', 'home-renovation-agency' ),
	) );

	//TP Genral Option
	$wp_customize->add_section('home_renovation_agency_tp_general_settings',array(
        'title' => __('TP General Option', 'home-renovation-agency'),
        'priority' => 1,
        'panel' => 'home_renovation_agency_panel_id'
    ) );
 	$wp_customize->add_setting('home_renovation_agency_tp_body_layout_settings',array(
		'default' => 'Full',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));

 	$wp_customize->add_control('home_renovation_agency_tp_body_layout_settings',array(
		'type' => 'radio',
		'label'     => __('Body Layout Setting', 'home-renovation-agency'),
		'description'   => __('This option work for complete body, if you want to set the complete website in container.', 'home-renovation-agency'),
		'section' => 'home_renovation_agency_tp_general_settings',
		'choices' => array(
		'Full' => __('Full','home-renovation-agency'),
		'Container' => __('Container','home-renovation-agency'),
		'Container Fluid' => __('Container Fluid','home-renovation-agency')
		),
	) );

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('home_renovation_agency_sidebar_post_layout',array(
     'default' => 'right',
     'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_sidebar_post_layout',array(
     'type' => 'radio',
     'label'     => __('Post Sidebar Position', 'home-renovation-agency'),
     'description'   => __('This option work for blog page, blog single page, archive page and search page.', 'home-renovation-agency'),
     'section' => 'home_renovation_agency_tp_general_settings',
     'choices' => array(
         'full' => __('Full','home-renovation-agency'),
         'left' => __('Left','home-renovation-agency'),
         'right' => __('Right','home-renovation-agency'),
         'three-column' => __('Three Columns','home-renovation-agency'),
         'four-column' => __('Four Columns','home-renovation-agency'),
         'grid' => __('Grid Layout','home-renovation-agency')
     ),
	) );

	// Add Settings and Controls for single post sidebar Layout
	$wp_customize->add_setting('home_renovation_agency_sidebar_single_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_sidebar_single_post_layout',array(
        'type' => 'radio',
        'label'     => __('Single Post Sidebar Position', 'home-renovation-agency'),
        'description'   => __('This option work for single blog page', 'home-renovation-agency'),
        'section' => 'home_renovation_agency_tp_general_settings',
        'choices' => array(
            'full' => __('Full','home-renovation-agency'),
            'left' => __('Left','home-renovation-agency'),
            'right' => __('Right','home-renovation-agency'),
        ),
	) );

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('home_renovation_agency_sidebar_page_layout',array(
     'default' => 'right',
     'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_sidebar_page_layout',array(
     'type' => 'radio',
     'label'     => __('Page Sidebar Position', 'home-renovation-agency'),
     'description'   => __('This option work for pages.', 'home-renovation-agency'),
     'section' => 'home_renovation_agency_tp_general_settings',
     'choices' => array(
         'full' => __('Full','home-renovation-agency'),
         'left' => __('Left','home-renovation-agency'),
         'right' => __('Right','home-renovation-agency')
     ),
	) );
	//tp typography option
	$home_renovation_agency_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'Inter'           		 => 'Inter',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Manrope'                  => 'Manrope',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	$wp_customize->add_section('home_renovation_agency_typography_option',array(
		'title'         => __('TP Typography Option', 'home-renovation-agency'),
		'priority' => 1,
		'panel' => 'home_renovation_agency_panel_id'
   	));

   	$wp_customize->add_setting('home_renovation_agency_heading_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices',
	));
	$wp_customize->add_control(	'home_renovation_agency_heading_font_family', array(
		'section' => 'home_renovation_agency_typography_option',
		'label'   => __('heading Fonts', 'home-renovation-agency'),
		'type'    => 'select',
		'choices' => $home_renovation_agency_font_array,
	));

	$wp_customize->add_setting('home_renovation_agency_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices',
	));
	$wp_customize->add_control(	'home_renovation_agency_body_font_family', array(
		'section' => 'home_renovation_agency_typography_option',
		'label'   => __('Body Fonts', 'home-renovation-agency'),
		'type'    => 'select',
		'choices' => $home_renovation_agency_font_array,
	));

	//TP Color Option
	$wp_customize->add_section('home_renovation_agency_color_option',array(
     'title'         => __('TP Color Option', 'home-renovation-agency'),
     'priority' => 1,
     'panel' => 'home_renovation_agency_panel_id'
    ) );
    
	$wp_customize->add_setting( 'home_renovation_agency_tp_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_tp_color_option', array(
			'label'     => __('Theme First Color', 'home-renovation-agency'),
	    'description' => __('It will change the complete theme color in one click.', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_color_option',
	    'settings' => 'home_renovation_agency_tp_color_option',
  	)));

	//TP Preloader Option
	$wp_customize->add_section('home_renovation_agency_prelaoder_option',array(
		'title'         => __('TP Preloader Option', 'home-renovation-agency'),
		'priority' => 1,
		'panel' => 'home_renovation_agency_panel_id'
	) );
	$wp_customize->add_setting( 'home_renovation_agency_preloader_show_hide', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_preloader_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Preloader Option', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_prelaoder_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_preloader_show_hide',
	) ) );
	$wp_customize->add_setting( 'home_renovation_agency_tp_preloader_color1_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_tp_preloader_color1_option', array(
			'label'     => __('Preloader First Ring Color', 'home-renovation-agency'),
	    'description' => __('It will change the complete theme preloader ring 1 color in one click.', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_prelaoder_option',
	    'settings' => 'home_renovation_agency_tp_preloader_color1_option',
  	)));
  	$wp_customize->add_setting( 'home_renovation_agency_tp_preloader_color2_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_tp_preloader_color2_option', array(
			'label'     => __('Preloader Second Ring Color', 'home-renovation-agency'),
	    'description' => __('It will change the complete theme preloader ring 2 color in one click.', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_prelaoder_option',
	    'settings' => 'home_renovation_agency_tp_preloader_color2_option',
  	)));
  	$wp_customize->add_setting( 'home_renovation_agency_tp_preloader_bg_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_tp_preloader_bg_color_option', array(
			'label'     => __('Preloader Background Color', 'home-renovation-agency'),
	    'description' => __('It will change the complete theme preloader bg color in one click.', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_prelaoder_option',
	    'settings' => 'home_renovation_agency_tp_preloader_bg_color_option',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_preloader_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_preloader_pro_version_logo', array(
        'section'     => 'home_renovation_agency_prelaoder_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//TP Blog Option
	$wp_customize->add_section('home_renovation_agency_blog_option',array(
		'title' => __('TP Blog Option', 'home-renovation-agency'),
		'priority' => 1,
		'panel' => 'home_renovation_agency_panel_id'
	) );

	$wp_customize->add_setting('home_renovation_agency_edit_blog_page_title',array(
		'default'=> __('Home','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_edit_blog_page_title',array(
		'label'	=> __('Change Blog Page Title','home-renovation-agency'),
		'section'=> 'home_renovation_agency_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_edit_blog_page_description',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_edit_blog_page_description',array(
		'label'	=> __('Add Blog Description','home-renovation-agency'),
		'section'=> 'home_renovation_agency_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('blog_meta_order', array(
        'default' => array('date', 'author', 'comment', 'category', 'time'),
        'sanitize_callback' => 'home_renovation_agency_sanitize_sortable',
    ));
    $wp_customize->add_control(new Home_Renovation_Agency_Control_Sortable($wp_customize, 'blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'home-renovation-agency'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'home-renovation-agency') ,
        'section' => 'home_renovation_agency_blog_option',
        'choices' => array(
            'date' => __('date', 'home-renovation-agency') ,
            'author' => __('author', 'home-renovation-agency') ,
            'comment' => __('comment', 'home-renovation-agency') ,
            'category' => __('category', 'home-renovation-agency') ,
            'time' => __('time', 'home-renovation-agency') ,
        ) ,
    )));

    $wp_customize->add_setting( 'home_renovation_agency_excerpt_count', array(
		'default'              => 35,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'home_renovation_agency_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'home_renovation_agency_excerpt_count', array(
		'label'       => esc_html__( 'Edit Excerpt Limit','home-renovation-agency' ),
		'section'     => 'home_renovation_agency_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('home_renovation_agency_show_first_caps',array(
        'default' => false,
        'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'home_renovation_agency_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'home-renovation-agency'),
		'type' => 'checkbox',
		'section' => 'home_renovation_agency_blog_option',
	));

	$wp_customize->add_setting('home_renovation_agency_read_more_text',array(
		'default'=> __('Read More','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_read_more_text',array(
		'label'	=> __('Edit Button Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_post_image_round', array(
	  'default' => '0',
      'sanitize_callback' => 'home_renovation_agency_sanitize_number_range',
	));
	$wp_customize->add_control(new home_renovation_agency_Range_Slider($wp_customize, 'home_renovation_agency_post_image_round', array(
       'section' => 'home_renovation_agency_blog_option',
      'label' => esc_html__('Edit Post Image Border Radius', 'home-renovation-agency'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 180,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('home_renovation_agency_post_image_width', array(
	  'default' => '',
      'sanitize_callback' => 'home_renovation_agency_sanitize_number_range',
	));
	$wp_customize->add_control(new home_renovation_agency_Range_Slider($wp_customize, 'home_renovation_agency_post_image_width', array(
       'section' => 'home_renovation_agency_blog_option',
      'label' => esc_html__('Edit Post Image Width', 'home-renovation-agency'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 367,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('home_renovation_agency_post_image_length', array(
	  'default' => '',
      'sanitize_callback' => 'home_renovation_agency_sanitize_number_range',
	));
	$wp_customize->add_control(new home_renovation_agency_Range_Slider($wp_customize, 'home_renovation_agency_post_image_length', array(
       'section' => 'home_renovation_agency_blog_option',
      'label' => esc_html__('Edit Post Image height', 'home-renovation-agency'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 900,
        'step' => 1
    )
	)));

	$wp_customize->add_setting( 'home_renovation_agency_remove_read_button', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_remove_read_button', array(
		'label'       => esc_html__( 'Show / Hide Read More Button', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_blog_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_remove_read_button',
	) ) );

    $wp_customize->selective_refresh->add_partial( 'home_renovation_agency_remove_read_button', array(
		'selector' => '.readmore-btn',
		'render_callback' => 'Home_Renovation_Agency_Customize_partial_home_renovation_agency_remove_read_button',
	 ));

	 $wp_customize->add_setting( 'home_renovation_agency_remove_tags', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_remove_tags', array(
		'label'       => esc_html__( 'Show / Hide Tags Option', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_blog_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_remove_tags',
	) ) );
    $wp_customize->selective_refresh->add_partial( 'home_renovation_agency_remove_tags', array(
		'selector' => '.box-content a[rel="tag"]',
		'render_callback' => 'Home_Renovation_Agency_Customize_partial_home_renovation_agency_remove_tags',
	));
	$wp_customize->add_setting( 'home_renovation_agency_remove_category', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_remove_category', array(
		'label'       => esc_html__( 'Show / Hide Category Option', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_blog_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_remove_category',
	) ) );
    $wp_customize->selective_refresh->add_partial( 'home_renovation_agency_remove_category', array(
		'selector' => '.box-content a[rel="category"]',
		'render_callback' => 'Home_Renovation_Agency_Customize_partial_home_renovation_agency_remove_category',
	));
	$wp_customize->add_setting( 'home_renovation_agency_remove_comment', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
 	) );

	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_remove_comment', array(
	 'label'       => esc_html__( 'Show / Hide Comment Form', 'home-renovation-agency' ),
	 'section'     => 'home_renovation_agency_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'home_renovation_agency_remove_comment',
	) ) );

	$wp_customize->add_setting( 'home_renovation_agency_remove_related_post', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
 	) );

	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_remove_related_post', array(
	 'label'       => esc_html__( 'Show / Hide Related Post', 'home-renovation-agency' ),
	 'section'     => 'home_renovation_agency_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'home_renovation_agency_remove_related_post',
	) ) );
	$wp_customize->add_setting( 'home_renovation_agency_related_post_per_page', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'home_renovation_agency_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'home_renovation_agency_related_post_per_page', array(
		'label'       => esc_html__( 'Related Post Per Page','home-renovation-agency' ),
		'section'     => 'home_renovation_agency_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 3,
			'max'              => 9,
		),
	) );

	//TP Single Blog Option
	$wp_customize->add_section('home_renovation_agency_single_blog_option',array(
        'title' => __('Single Post Option', 'home-renovation-agency'),
        'priority' => 1,
        'panel' => 'home_renovation_agency_panel_id'
    ) );

    /** Meta Order */
    $wp_customize->add_setting('home_renovation_agency_single_blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'home_renovation_agency_sanitize_sortable',
    ));
    $wp_customize->add_control(new home_renovation_agency_Control_Sortable($wp_customize, 'home_renovation_agency_single_blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'home-renovation-agency'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'home-renovation-agency') ,
        'section' => 'home_renovation_agency_single_blog_option',
        'choices' => array(
            'date' => __('date', 'home-renovation-agency') ,
            'author' => __('author', 'home-renovation-agency') ,
            'comment' => __('comment', 'home-renovation-agency') ,
            'category' => __('category', 'home-renovation-agency') ,
            'time' => __('time', 'home-renovation-agency') ,
        ) ,
    )));

    $wp_customize->add_setting('home_renovation_agency_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
       $wp_customize,'home_renovation_agency_single_post_date_icon',array(
		'label'	=> __('Change Date Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_single_blog_option',
		'type'		=> 'home-renovation-agency-icon'
	)));

	$wp_customize->add_setting('home_renovation_agency_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
       $wp_customize,'home_renovation_agency_single_post_author_icon',array(
		'label'	=> __('Change Author Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_single_blog_option',
		'type'		=> 'home-renovation-agency-icon'
	)));

	$wp_customize->add_setting('home_renovation_agency_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
       $wp_customize,'home_renovation_agency_single_post_comment_icon',array(
		'label'	=> __('Change Comment Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_single_blog_option',
		'type'		=> 'home-renovation-agency-icon'
	)));

	$wp_customize->add_setting('home_renovation_agency_single_post_category_icon',array(
		'default'	=> 'fas fa-list',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
       $wp_customize,'home_renovation_agency_single_post_category_icon',array(
		'label'	=> __('Change Category Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_single_blog_option',
		'type'		=> 'home-renovation-agency-icon'
	)));

	$wp_customize->add_setting('home_renovation_agency_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
       $wp_customize,'home_renovation_agency_single_post_time_icon',array(
		'label'	=> __('Change Time Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_single_blog_option',
		'type'		=> 'home-renovation-agency-icon'
	)));

	 //MENU TYPOGRAPHY
	$wp_customize->add_section( 'home_renovation_agency_menu_typography', array(
    	'title'      => __( 'Menu Typography', 'home-renovation-agency' ),
    	'priority' => 2,
		'panel' => 'home_renovation_agency_panel_id'
	) );
	$wp_customize->add_setting('home_renovation_agency_menu_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices',
	));
	$wp_customize->add_control(	'home_renovation_agency_menu_font_family', array(
		'section' => 'home_renovation_agency_menu_typography',
		'label'   => __('Menu Fonts', 'home-renovation-agency'),
		'type'    => 'select',
		'choices' => $home_renovation_agency_font_array,
	));

	$wp_customize->add_setting('home_renovation_agency_menu_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
 	));
 	$wp_customize->add_control('home_renovation_agency_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','home-renovation-agency'),
		'section' => 'home_renovation_agency_menu_typography',
		'choices' => array(
		   'Uppercase' => __('Uppercase','home-renovation-agency'),
		   'Lowercase' => __('Lowercase','home-renovation-agency'),
		   'Capitalize' => __('Capitalize','home-renovation-agency'),
		),
	) );
	
	$wp_customize->add_setting('home_renovation_agency_menu_font_size', array(
	  'default' => '',
      'sanitize_callback' => 'home_renovation_agency_sanitize_number_range',
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Range_Slider($wp_customize, 'home_renovation_agency_menu_font_size', array(
       'section' => 'home_renovation_agency_menu_typography',
      'label' => esc_html__('Font Size', 'home-renovation-agency'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 20,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('home_renovation_agency_menus_item_style',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_menus_item_style',array(
		'type' => 'select',
		'section' => 'home_renovation_agency_menu_typography',
		'label' => __('Menu Hover Effect','home-renovation-agency'),
		'choices' => array(
			'None' => __('None','home-renovation-agency'),
			'Zoom In' => __('Zoom In','home-renovation-agency'),
		),
	) );

	$wp_customize->add_setting( 'home_renovation_agency_menu_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_menu_color', array(
			'label'     => __('Change Menu Color', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_menu_typography',
	    'settings' => 'home_renovation_agency_menu_color',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_menu_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_menu_pro_version_logo', array(
        'section'     => 'home_renovation_agency_menu_typography',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// Top bar Section
	$wp_customize->add_section( 'home_renovation_agency_topbar', array(
    	'title'      => __( 'Header Details', 'home-renovation-agency' ),
    	'description' => __( 'Add your contact details', 'home-renovation-agency' ),
		'panel' => 'home_renovation_agency_panel_id',
      'priority' => 2,
	) );

	$wp_customize->add_setting('home_renovation_agency_header_button',array(
		'default'=> __('Get Start','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_header_button',array(
		'label'	=> __('Header Button Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_header_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('home_renovation_agency_header_link',array(
		'label'	=> __('Header Button Link','home-renovation-agency'),
		'section'=> 'home_renovation_agency_topbar',
		'type'=> 'url'
	));

	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_header_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_header_pro_version_logo', array(
        'section'     => 'home_renovation_agency_topbar',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//home page slider
	$wp_customize->add_section( 'home_renovation_agency_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'home-renovation-agency' ),
		'panel' => 'home_renovation_agency_panel_id',
      	'priority' => 3,
	) );

	$wp_customize->add_setting( 'home_renovation_agency_slider_arrows', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_slider_arrows', array(
		'label'       => esc_html__( 'Show / Hide slider', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_slider_section',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_slider_arrows',
	) ) );

	$wp_customize->add_setting( 'home_renovation_agency_show_slider_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new home_renovation_agency_Toggle_Control( $wp_customize, 'home_renovation_agency_show_slider_title', array(
		'label'       => esc_html__( 'Show / Hide Slider Heading', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_slider_section',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_show_slider_title',
	) ) );

	$wp_customize->add_setting( 'home_renovation_agency_show_slider_content', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new home_renovation_agency_Toggle_Control( $wp_customize, 'home_renovation_agency_show_slider_content', array(
		'label'       => esc_html__( 'Show / Hide Slider Content', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_slider_section',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_show_slider_content',
	) ) );

	$wp_customize->add_setting('home_renovation_agency_slider_side_text',array(
		'default'=> __('Home Renovation','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_slider_side_text',array(
		'label'	=> __('Add Slider Side Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_slider_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_slider_short_heading',array(
		'label'	=> __('Add short Heading','home-renovation-agency'),
		'section'=> 'home_renovation_agency_slider_section',
		'type'=> 'text'
	));

	for ( $home_renovation_agency_count = 1; $home_renovation_agency_count <= 4; $home_renovation_agency_count++ ) {

	// Add color scheme setting and control.
	$wp_customize->add_setting( 'home_renovation_agency_slider_page' . $home_renovation_agency_count, array(
		'default'           => '',
		'sanitize_callback' => 'home_renovation_agency_sanitize_dropdown_pages'
	) );

	$wp_customize->add_control( 'home_renovation_agency_slider_page' . $home_renovation_agency_count, array(
		'label'    => __( 'Select Slide Image Page', 'home-renovation-agency' ),
		'section'  => 'home_renovation_agency_slider_section',
		'type'     => 'dropdown-pages'
	) );

	}

	$wp_customize->add_setting('home_renovation_agency_call_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_call_text',array(
		'label'	=> __('Add Phone Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_phone_number'
	));
	$wp_customize->add_control('home_renovation_agency_call',array(
		'label'	=> __('Add Phone Number','home-renovation-agency'),
		'section'=> 'home_renovation_agency_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_total_no_award_winning',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_total_no_award_winning',array(
		'label'	=> __('Add Total Number of Award Winning','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_slider_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_total_no_project_complete',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_total_no_project_complete',array(
		'label'	=> __('Add Total Number of Project Complete','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_slider_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('home_renovation_agency_total_no_happy_client',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_total_no_happy_client',array(
		'label'	=> __('Add Total Number of Happy Client','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_slider_section',
		'type'		=> 'text'
	));

	//Slider excerpt
	$wp_customize->add_setting( 'home_renovation_agency_slider_excerpt_length', array(
		'default'              => 50,
		'sanitize_callback'	=> 'absint',
	) );
	$wp_customize->add_control( 'home_renovation_agency_slider_excerpt_length', array(
		'label'       => esc_html__( 'Slider Content length','home-renovation-agency' ),
		'section'     => 'home_renovation_agency_slider_section',
		'type'        => 'number',
		'settings'    => 'home_renovation_agency_slider_excerpt_length',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	//Slider height
    $wp_customize->add_setting('home_renovation_agency_slider_img_height',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('home_renovation_agency_slider_img_height',array(
        'label' => __('Slider Height','home-renovation-agency'),
        'description'   => __('Add slider height in px(eg. 700px).','home-renovation-agency'),
        'section'=> 'home_renovation_agency_slider_section',
        'type'=> 'text'
    ));

	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_slider_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_slider_pro_version_logo', array(
        'section'     => 'home_renovation_agency_slider_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// About Us Section
	$wp_customize->add_section('home_renovation_agency_about_section', array(
	    'title'    => __('About Us Section', 'home-renovation-agency'),
	    'panel'    => 'home_renovation_agency_panel_id',
	    'priority' => 7,
	));

	$wp_customize->add_setting('home_renovation_agency_about_enable', array(
	    'default'           => true,
	    'transport'         => 'refresh',
	    'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Toggle_Control($wp_customize, 'home_renovation_agency_about_enable', array(
	    'label'    => esc_html__('Show / Hide Section', 'home-renovation-agency'),
	    'section'  => 'home_renovation_agency_about_section',
	    'type'     => 'toggle',
	    'settings' => 'home_renovation_agency_about_enable',
	)));

	$wp_customize->add_setting('home_renovation_agency_service_sub_heading', array(
	    'default'           => '',
	    'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_service_sub_heading', array(
	    'label'    => __('Section Sub Title', 'home-renovation-agency'),
	    'section'  => 'home_renovation_agency_about_section',
	    'type'     => 'text'
	));

	// Add a default "Select" option to the dropdown
	$wp_customize->add_setting('home_renovation_agency_about_page', array(
	    'default'           => '0', 
	    'sanitize_callback' => 'home_renovation_agency_sanitize_dropdown_pages'
	));
	$wp_customize->add_control('home_renovation_agency_about_page', array(
	    'label'    => __('Select About Page', 'home-renovation-agency'),
	    'section'  => 'home_renovation_agency_about_section',
	    'type'     => 'dropdown-pages'
	));

  	// YouTube URL
	$wp_customize->add_setting(
	    'home_renovation_agency_youtube_url',
	    array(
	        'default'           => '',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);
	$wp_customize->add_control(
	    'home_renovation_agency_youtube_url',
	    array(
	        'type'    => 'url',
	        'label'   => __('YouTube URL', 'home-renovation-agency'),
	        'section' => 'home_renovation_agency_about_section',
	    )
	);

	for($home_renovation_agency_i=1;$home_renovation_agency_i<=2;$home_renovation_agency_i++) {

	    $wp_customize->add_setting('home_renovation_agency_tab_icon'.$home_renovation_agency_i,array(
			'default'	=> 'fas fa-address-book',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
	        $wp_customize,'home_renovation_agency_tab_icon'.$home_renovation_agency_i,array(
			'label'	=> __('About Text Icon','home-renovation-agency').$home_renovation_agency_i,
			'transport' => 'refresh',
			'section'	=> 'home_renovation_agency_about_section',
			'type'		=> 'icon'
		)));

	    $wp_customize->add_setting('home_renovation_agency_tab_heading'.$home_renovation_agency_i,array(
	        'default'=> '',
	        'sanitize_callback' => 'sanitize_text_field'
	    ));
	    $wp_customize->add_control('home_renovation_agency_tab_heading'.$home_renovation_agency_i,array(
	        'label' => __('About Text ','home-renovation-agency').$home_renovation_agency_i,
	        'section'=> 'home_renovation_agency_about_section',
	        'setting'=> 'home_renovation_agency_tab_heading'.$home_renovation_agency_i,
	        'type'=> 'text'
	    ));
  	}

  	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_about_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_about_pro_version_logo', array(
        'section'     => 'home_renovation_agency_about_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//footer
	$wp_customize->add_section('home_renovation_agency_footer_section',array(
		'title'	=> __('Footer Widget Settings','home-renovation-agency'),
		'panel' => 'home_renovation_agency_panel_id',
		'priority' => 7,
	));

	// footer columns
	$wp_customize->add_setting('home_renovation_agency_footer_columns',array(
		'default'	=> 4,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_footer_columns',array(
		'label'	=> __('Footer Widget Columns','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_footer_section',
		'setting'	=> 'home_renovation_agency_footer_columns',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	));
	$wp_customize->add_setting( 'home_renovation_agency_tp_footer_bg_color_option', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_tp_footer_bg_color_option', array(
			'label'     => __('Footer Widget Background Color', 'home-renovation-agency'),
			'description' => __('It will change the complete footer widget backgorund color.', 'home-renovation-agency'),
			'section' => 'home_renovation_agency_footer_section',
			'settings' => 'home_renovation_agency_tp_footer_bg_color_option',
	)));
	$wp_customize->add_setting('home_renovation_agency_footer_widget_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'home_renovation_agency_footer_widget_image',array(
        'label' => __('Footer Widget Background Image','home-renovation-agency'),
         'section' => 'home_renovation_agency_footer_section'
	)));

	//footer widget title font size
	$wp_customize->add_setting('home_renovation_agency_footer_widget_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_footer_widget_title_font_size',array(
		'label'	=> __('Change Footer Widget Title Font Size in PX','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_footer_section',
	    'setting'	=> 'home_renovation_agency_footer_widget_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'home_renovation_agency_footer_widget_title_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_footer_widget_title_color', array(
			'label'     => __('Change Footer Widget Title Color', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_footer_section',
	    'settings' => 'home_renovation_agency_footer_widget_title_color',
  	)));

  	$wp_customize->add_setting('home_renovation_agency_footer_widget_title_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_footer_widget_title_font_weight',array(
     'type' => 'radio',
     'label'     => __('Change Footer Widget Title Font Weight', 'home-renovation-agency'),
     'section' => 'home_renovation_agency_footer_section',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','home-renovation-agency'),
         '200' => __('200','home-renovation-agency'),
         '300' => __('300','home-renovation-agency'),
         '400' => __('400','home-renovation-agency'),
         '500' => __('500','home-renovation-agency'),
         '600' => __('600','home-renovation-agency'),
         '700' => __('700','home-renovation-agency'),
         '800' => __('800','home-renovation-agency'),
         '900' => __('900','home-renovation-agency')
     ),
	) );

	$wp_customize->add_setting('home_renovation_agency_footer_widget_title_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
 	));
 	$wp_customize->add_control('home_renovation_agency_footer_widget_title_text_tranform',array(
		'type' => 'select',
		'label' => __('Change Footer Widget Title Letter Case','home-renovation-agency'),
		'section' => 'home_renovation_agency_footer_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','home-renovation-agency'),
		   'Lowercase' => __('Lowercase','home-renovation-agency'),
		   'Capitalize' => __('Capitalize','home-renovation-agency'),
		),
	) );

	// Add Settings and Controls for position
	$wp_customize->add_setting('home_renovation_agency_footer_widget_title_position',array(
        'default' => '',
        'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_footer_widget_title_position',array(
        'type' => 'radio',
        'label'     => __('Change Footer Widget Position', 'home-renovation-agency'),
        'description'   => __('This option work for Footer Widget', 'home-renovation-agency'),
        'section' => 'home_renovation_agency_footer_section',
        'choices' => array(
            'Right' => __('Right','home-renovation-agency'),
            'Left' => __('Left','home-renovation-agency'),
            'Center' => __('Center','home-renovation-agency')
        ),
	) );
  	
	$wp_customize->add_setting( 'home_renovation_agency_return_to_header', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_return_to_header', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_footer_section',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_return_to_header',
	) ) );
    $wp_customize->add_setting('home_renovation_agency_scroll_top_icon',array(
	  'default'	=> 'fas fa-arrow-up',
	  'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Home_Renovation_Agency_Icon_Changer(
	        $wp_customize,'home_renovation_agency_scroll_top_icon',array(
		'label'	=> __('Scroll to top Icon','home-renovation-agency'),
		'transport' => 'refresh',
		'section'	=> 'home_renovation_agency_footer_section',
			'type'		=> 'icon'
	)));

    // Add Settings and Controls for Scroll top
	$wp_customize->add_setting('home_renovation_agency_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_scroll_top_position',array(
        'type' => 'radio',
        'label'     => __('Scroll to top Position', 'home-renovation-agency'),
        'description'   => __('This option work for scroll to top', 'home-renovation-agency'),
       'section' => 'home_renovation_agency_footer_section',
       'choices' => array(
            'Right' => __('Right','home-renovation-agency'),
            'Left' => __('Left','home-renovation-agency'),
            'Center' => __('Center','home-renovation-agency')
     ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_footer_widget_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_footer_widget_pro_version_logo', array(
        'section'     => 'home_renovation_agency_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//footer
	$wp_customize->add_section('home_renovation_agency_footer_copyright_section',array(
		'title'	=> __('Footer Copyright Settings','home-renovation-agency'),
		'description'	=> __('Add copyright text.','home-renovation-agency'),
		'panel' => 'home_renovation_agency_panel_id',
		'priority' => 8,
	));

	$wp_customize->add_setting('home_renovation_agency_footer_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_footer_text',array(
		'label'	=> __('Copyright Text','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_footer_copyright_section',
		'type'		=> 'text'
	));

	//footer widget title font size
	$wp_customize->add_setting('home_renovation_agency_footer_copyright_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_footer_copyright_font_size',array(
		'label'	=> __('Change Footer Copyright Font Size in PX','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_footer_copyright_section',
	    'setting'	=> 'home_renovation_agency_footer_copyright_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'home_renovation_agency_footer_copyright_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_footer_copyright_text_color', array(
			'label'     => __('Change Footer Copyright Text Color', 'home-renovation-agency'),
	    'section' => 'home_renovation_agency_footer_copyright_section',
	    'settings' => 'home_renovation_agency_footer_copyright_text_color',
  	)));

  	$wp_customize->add_setting('home_renovation_agency_footer_copyright_top_bottom_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_footer_copyright_top_bottom_padding',array(
		'label'	=> __('Change Footer Copyright Padding in PX','home-renovation-agency'),
		'section'	=> 'home_renovation_agency_footer_copyright_section',
	    'setting'	=> 'home_renovation_agency_footer_copyright_top_bottom_padding',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// Add Settings and Controls for copyright
	$wp_customize->add_setting('home_renovation_agency_copyright_text_position',array(
        'default' => 'Center',
        'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
	$wp_customize->add_control('home_renovation_agency_copyright_text_position',array(
        'type' => 'radio',
        'label'     => __('Copyright Text Position', 'home-renovation-agency'),
        'description'   => __('This option work for Copyright', 'home-renovation-agency'),
        'section' => 'home_renovation_agency_footer_copyright_section',
        'choices' => array(
            'Right' => __('Right','home-renovation-agency'),
            'Left' => __('Left','home-renovation-agency'),
            'Center' => __('Center','home-renovation-agency')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_copyright_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_copyright_pro_version_logo', array(
        'section'     => 'home_renovation_agency_footer_copyright_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'Home_Renovation_Agency_Customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'Home_Renovation_Agency_Customize_partial_blogdescription',
	) );

	//Mobile Respnsive
	$wp_customize->add_section('home_renovation_agency_mobile_media_option',array(
		'title'         => __('Mobile Responsive media', 'home-renovation-agency'),
		'description' => __('Control will not function if the toggle in the main settings is off.', 'home-renovation-agency'),
		'priority' => 8,
		'panel' => 'home_renovation_agency_panel_id'
	) );

	$wp_customize->add_setting( 'home_renovation_agency_mobile_blog_description', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new home_renovation_agency_Toggle_Control( $wp_customize, 'home_renovation_agency_mobile_blog_description', array(
		'label'       => esc_html__( 'Show / Hide Blog Page Description', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_mobile_blog_description',
	) ) );

	$wp_customize->add_setting( 'home_renovation_agency_return_to_header_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_return_to_header_mob', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_return_to_header_mob',
	) ) );
	$wp_customize->add_setting( 'home_renovation_agency_related_post_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_related_post_mob', array(
		'label'       => esc_html__( 'Show / Hide Related Post', 'home-renovation-agency' ),
		'section'     => 'home_renovation_agency_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_related_post_mob',
	) ) );

	//Slider height
    $wp_customize->add_setting('home_renovation_agency_slider_img_height_responsive',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('home_renovation_agency_slider_img_height_responsive',array(
        'label' => __('Slider Height','home-renovation-agency'),
        'description'   => __('Add slider height in px(eg. 700px).','home-renovation-agency'),
        'section'=> 'home_renovation_agency_mobile_media_option',
        'type'=> 'text'
    ));

	// Pro Version
    $wp_customize->add_setting( 'home_renovation_agency_responsive_pro_version_logo', array(
        'sanitize_callback' => 'home_renovation_agency_sanitize_custom_control'
    ));
    $wp_customize->add_control( new home_renovation_agency_Customize_Pro_Version ( $wp_customize,'home_renovation_agency_responsive_pro_version_logo', array(
        'section'     => 'home_renovation_agency_mobile_media_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'home-renovation-agency' ),
        'description' => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//Site Identity
	$wp_customize->add_setting( 'home_renovation_agency_site_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_site_title', array(
		'label'       => esc_html__( 'Show / Hide Site Title', 'home-renovation-agency' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_site_title',
	) ) );
	$wp_customize->add_setting('home_renovation_agency_site_title_font_size',array(
		'default'	=> 30,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_site_title_font_size',array(
		'label'	=> __('Site Title Font Size in PX','home-renovation-agency'),
		'section'	=> 'title_tagline',
		'setting'	=> 'home_renovation_agency_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 80,
		),
	));

	$wp_customize->add_setting( 'home_renovation_agency_site_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_site_tagline_color', array(
			'label'     => __('Change Site Title Color', 'home-renovation-agency'),
	    'section' => 'title_tagline',
	    'settings' => 'home_renovation_agency_site_tagline_color',
  	)));

	$wp_customize->add_setting( 'home_renovation_agency_site_tagline', array(
	    'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_site_tagline', array(
		'label'       => esc_html__( 'Show / Hide Site Tagline', 'home-renovation-agency' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_site_tagline',
	) ) );

	// logo site tagline size
	$wp_customize->add_setting('home_renovation_agency_site_tagline_font_size',array(
		'default'	=> 15,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size in PX','home-renovation-agency'),
		'section'	=> 'title_tagline',
	    'setting'	=> 'home_renovation_agency_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'home_renovation_agency_logo_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_logo_tagline_color', array(
			'label'     => __('Change Site Tagline Color', 'home-renovation-agency'),
	    'section' => 'title_tagline',
	    'settings' => 'home_renovation_agency_logo_tagline_color',
  	)));

    $wp_customize->add_setting('home_renovation_agency_logo_width',array(
		'default' => 50,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_logo_width',array(
		'label'	=> esc_html__('Here You Can Customize Your Logo Size','home-renovation-agency'),
		'section'	=> 'title_tagline',
		'type'		=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 150,
		),
	));

	//Woo Coomerce
	$wp_customize->add_setting('home_renovation_agency_per_columns',array(
		'default'=> 3,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_per_columns',array(
		'label'	=> __('Product Per Row','home-renovation-agency'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));
	$wp_customize->add_setting('home_renovation_agency_product_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'home_renovation_agency_sanitize_number_absint'
	));
	$wp_customize->add_control('home_renovation_agency_product_per_page',array(
		'label'	=> __('Product Per Page','home-renovation-agency'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));
   	$wp_customize->add_setting( 'home_renovation_agency_product_sidebar', array(
		 'default'           => true,
		 'transport'         => 'refresh',
		 'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Shop Page Sidebar', 'home-renovation-agency' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_product_sidebar',
	) ) );

	$wp_customize->add_setting( 'home_renovation_agency_single_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_single_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Product Page Sidebar', 'home-renovation-agency' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_single_product_sidebar',
	) ) );
	$wp_customize->add_setting( 'home_renovation_agency_related_product', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Home_Renovation_Agency_Toggle_Control( $wp_customize, 'home_renovation_agency_related_product', array(
		'label'       => esc_html__( 'Show / Hide related product', 'home-renovation-agency' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'home_renovation_agency_related_product',
	) ) );
	
	//add page template setting pannel
	$wp_customize->add_panel( 'home_renovation_agency_page_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Page Template Settings', 'home-renovation-agency' ),
	    'description' => __( 'Description of what this panel does.', 'home-renovation-agency' ),
	) );

	// 404 PAGE
	$wp_customize->add_section('home_renovation_agency_404_page_section',array(
		'title'         => __('404 Page', 'home-renovation-agency'),
		'description'   => 'Here you can customize 404 Page content.',
		'panel' => 'home_renovation_agency_page_panel_id'
	) );

	$wp_customize->add_setting('home_renovation_agency_edit_404_title',array(
		'default'=> __('Oops! That page cant be found.','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('home_renovation_agency_edit_404_title',array(
		'label'	=> __('Edit Title','home-renovation-agency'),
		'section'=> 'home_renovation_agency_404_page_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('home_renovation_agency_edit_404_text',array(
		'default'=> __('It looks like nothing was found at this location. Maybe try a search?','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_edit_404_text',array(
		'label'	=> __('Edit Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_404_page_section',
		'type'=> 'text'
	));

	// Search Results
	$wp_customize->add_section('home_renovation_agency_no_result_section',array(
		'title'         => __('Search Results', 'home-renovation-agency'),
		'description'   => 'Here you can customize Search Result content.',
		'panel' => 'home_renovation_agency_page_panel_id'
	) );

	$wp_customize->add_setting('home_renovation_agency_edit_no_result_title',array(
		'default'=> __('Nothing Found','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('home_renovation_agency_edit_no_result_title',array(
		'label'	=> __('Edit Title','home-renovation-agency'),
		'section'=> 'home_renovation_agency_no_result_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('home_renovation_agency_edit_no_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','home-renovation-agency'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('home_renovation_agency_edit_no_result_text',array(
		'label'	=> __('Edit Text','home-renovation-agency'),
		'section'=> 'home_renovation_agency_no_result_section',
		'type'=> 'text'
	));

	// Header Image Height
    $wp_customize->add_setting(
        'home_renovation_agency_header_image_height',
        array(
            'default'           => 350,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'home_renovation_agency_header_image_height',
        array(
            'label'       => esc_html__( 'Header Image Height', 'home-renovation-agency' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the height of the header image. Default is 350px.', 'home-renovation-agency' ),
            'input_attrs' => array(
                'min'  => 220,
                'max'  => 1000,
                'step' => 1,
            ),
        )
    );

    // Header Background Position
    $wp_customize->add_setting(
        'home_renovation_agency_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'home_renovation_agency_header_background_position',
        array(
            'label'       => esc_html__( 'Header Background Position', 'home-renovation-agency' ),
            'section'     => 'header_image',
            'type'        => 'select',
            'choices'     => array(
                'top'    => esc_html__( 'Top', 'home-renovation-agency' ),
                'center' => esc_html__( 'Center', 'home-renovation-agency' ),
                'bottom' => esc_html__( 'Bottom', 'home-renovation-agency' ),
            ),
            'description' => esc_html__( 'Choose how you want to position the header image.', 'home-renovation-agency' ),
        )
    );

    // Header Image Parallax Effect
    $wp_customize->add_setting(
        'home_renovation_agency_header_background_attachment',
        array(
            'default'           => 1,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'home_renovation_agency_header_background_attachment',
        array(
            'label'       => esc_html__( 'Header Image Parallax', 'home-renovation-agency' ),
            'section'     => 'header_image',
            'type'        => 'checkbox',
            'description' => esc_html__( 'Add a parallax effect on page scroll.', 'home-renovation-agency' ),
        )
    );
    
    //Opacity
	$wp_customize->add_setting('home_renovation_agency_header_banner_opacity_color',array(
       'default'              => '0.5',
       'sanitize_callback' => 'home_renovation_agency_sanitize_choices'
	));
    $wp_customize->add_control( 'home_renovation_agency_header_banner_opacity_color', array(
		'label'       => esc_html__( 'Header Image Opacity','home-renovation-agency' ),
		'section'     => 'header_image',
		'type'        => 'select',
		'settings'    => 'home_renovation_agency_header_banner_opacity_color',
		'choices' => array(
           '0' =>  esc_attr(__('0','home-renovation-agency')),
           '0.1' =>  esc_attr(__('0.1','home-renovation-agency')),
           '0.2' =>  esc_attr(__('0.2','home-renovation-agency')),
           '0.3' =>  esc_attr(__('0.3','home-renovation-agency')),
           '0.4' =>  esc_attr(__('0.4','home-renovation-agency')),
           '0.5' =>  esc_attr(__('0.5','home-renovation-agency')),
           '0.6' =>  esc_attr(__('0.6','home-renovation-agency')),
           '0.7' =>  esc_attr(__('0.7','home-renovation-agency')),
           '0.8' =>  esc_attr(__('0.8','home-renovation-agency')),
           '0.9' =>  esc_attr(__('0.9','home-renovation-agency'))
		), 
	) );

   $wp_customize->add_setting( 'home_renovation_agency_header_banner_image_overlay', array(
	    'default'   => true,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'home_renovation_agency_sanitize_checkbox',
	));
	$wp_customize->add_control( new home_renovation_agency_Toggle_Control( $wp_customize, 'home_renovation_agency_header_banner_image_overlay', array(
	    'label'   => esc_html__( 'Show / Hide Header Image Overlay', 'home-renovation-agency' ),
	    'section' => 'header_image',
	)));

    $wp_customize->add_setting('home_renovation_agency_header_banner_image_ooverlay_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'home_renovation_agency_header_banner_image_ooverlay_color', array(
		'label'    => __('Header Image Overlay Color', 'home-renovation-agency'),
		'section'  => 'header_image',
	)));

    $wp_customize->add_setting(
        'home_renovation_agency_header_image_title_font_size',
        array(
            'default'           => 32,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'home_renovation_agency_header_image_title_font_size',
        array(
            'label'       => esc_html__( 'Change Header Image Title Font Size', 'home-renovation-agency' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the font Size of the header image title. Default is 32px.', 'home-renovation-agency' ),
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 200,
                'step' => 1,
            ),
        )
    );

	$wp_customize->add_setting( 'home_renovation_agency_header_image_title_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'home_renovation_agency_header_image_title_text_color', array(
			'label'     => __('Change Header Image Title Color', 'home-renovation-agency'),
	    'section' => 'header_image',
	    'settings' => 'home_renovation_agency_header_image_title_text_color',
  	)));

}
add_action( 'customize_register', 'Home_Renovation_Agency_Customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since Home Renovation Agency 1.0
 * @see Home_Renovation_Agency_Customize_register()
 *
 * @return void
 */
function Home_Renovation_Agency_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Home Renovation Agency 1.0
 * @see Home_Renovation_Agency_Customize_register()
 *
 * @return void
 */
function Home_Renovation_Agency_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if ( ! defined( 'HOME_RENOVATION_AGENCY_PRO_THEME_NAME' ) ) {
	define( 'HOME_RENOVATION_AGENCY_PRO_THEME_NAME', esc_html__( 'Home Renovation Pro', 'home-renovation-agency' ));
}
if ( ! defined( 'HOME_RENOVATION_AGENCY_PRO_THEME_URL' ) ) {
	define( 'HOME_RENOVATION_AGENCY_PRO_THEME_URL', esc_url('https://www.themespride.com/products/renovation-services-wordpress-theme'));
}
if ( ! defined( 'HOME_RENOVATION_AGENCY_DOCS_URL' ) ) {
	define( 'HOME_RENOVATION_AGENCY_DOCS_URL', esc_url('https://page.themespride.com/demo/docs/home-renovation-services/'));
}


if ( ! defined( 'HOME_RENOVATION_AGENCY_TEXT' ) ) {
    define( 'HOME_RENOVATION_AGENCY_TEXT', __( 'Home Renovation Agency Pro','home-renovation-agency' ));
}
if ( ! defined( 'HOME_RENOVATION_AGENCY_BUY_TEXT' ) ) {
    define( 'HOME_RENOVATION_AGENCY_BUY_TEXT', __( 'Upgrade Pro','home-renovation-agency' ));
}


add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( home_renovation_agency_Button::class );

    $manager->add_section(
        new home_renovation_agency_Button( $manager, 'home_renovation_agency_pro', [
            'title'       => esc_html( HOME_RENOVATION_AGENCY_TEXT,'home-renovation-agency' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'home-renovation-agency' ),
            'button_url'  => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL )
        ] )
    );

} );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Home_Renovation_Agency_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Home_Renovation_Agency_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Home_Renovation_Agency_Customize_Section_Pro(
				$manager,
				'home_renovation_agency_section_pro',
				array(
					'priority'   => 9,
					'title'    => HOME_RENOVATION_AGENCY_PRO_THEME_NAME,
					'pro_text' => esc_html__( 'Upgrade Pro', 'home-renovation-agency' ),
					'pro_url'  => esc_url( HOME_RENOVATION_AGENCY_PRO_THEME_URL, 'home-renovation-agency' ),
				)
			)
		);

		// Register sections.
		$manager->add_section(
			new home_renovation_agency_Customize_Section_Pro(
				$manager,
				'home_renovation_agency_documentation',
				array(
					'priority'   => 500,
					'title'    => esc_html__( 'Theme Documentation', 'home-renovation-agency' ),
					'pro_text' => esc_html__( 'Click Here', 'home-renovation-agency' ),
					'pro_url'  => esc_url( HOME_RENOVATION_AGENCY_DOCS_URL, 'home-renovation-agency'),
				)
			)
		);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'home-renovation-agency-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'home-renovation-agency-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Home_Renovation_Agency_Customize::get_instance();