<?php
/**
 * Custom header implementation
 *
 * @link https://codex.wordpress.org/Custom_Headers
 *
 * @package Home Renovation Agency
 * @subpackage home_renovation_agency
 */

function home_renovation_agency_custom_header_setup() {
    register_default_headers( array(
        'default-image' => array(
            'url'           => get_template_directory_uri() . '/assets/images/header_img.png',
            'thumbnail_url' => get_template_directory_uri() . '/assets/images/header_img.png',
            'description'   => __( 'Default Header Image', 'home-renovation-agency' ),
        ),
    ) );
}
add_action( 'after_setup_theme', 'home_renovation_agency_custom_header_setup' );

/**
 * Styles the header image based on Customizer settings.
 */
function home_renovation_agency_header_style() {
    $home_renovation_agency_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/assets/images/header_img.png';

    $home_renovation_agency_height     = get_theme_mod( 'home_renovation_agency_header_image_height', 350 );
    $home_renovation_agency_position   = get_theme_mod( 'home_renovation_agency_header_background_position', 'center' );
    $home_renovation_agency_attachment = get_theme_mod( 'home_renovation_agency_header_background_attachment', 1 ) ? 'fixed' : 'scroll';

    $home_renovation_agency_custom_css = "
        .header-img, .single-page-img, .external-div .box-image-page img, .external-div {
            background-image: url('" . esc_url( $home_renovation_agency_header_image ) . "');
            background-size: cover;
            height: " . esc_attr( $home_renovation_agency_height ) . "px;
            background-position: " . esc_attr( $home_renovation_agency_position ) . ";
            background-attachment: " . esc_attr( $home_renovation_agency_attachment ) . ";
        }

        @media (max-width: 1000px) {
            .header-img, .single-page-img, .external-div .box-image-page img,.external-div,.featured-image{
                height: 250px !important;
            }
            .box-text h2{
                font-size: 27px;
            }
        }
    ";

    wp_add_inline_style( 'home-renovation-agency-style', $home_renovation_agency_custom_css );
}
add_action( 'wp_enqueue_scripts', 'home_renovation_agency_header_style' );

/**
 * Enqueue the main theme stylesheet.
 */
function home_renovation_agency_enqueue_styles() {
    wp_enqueue_style( 'home-renovation-agency-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'home_renovation_agency_enqueue_styles' );