<?php
/**
 * This is the custom meta box for the Home Experts Pro theme.
 *
 * @return void
 */

/**
 * Home Experts Pro Metabox for Sidebar Layout
 *
 * @package Home Experts Pro
 */
function home_experts_add_sidebar_layout_box() {
	add_meta_box(
		'home_experts_sidebar_layout',
		__( 'Sidebar Layout', 'home-experts' ),
		'home_experts_sidebar_layout_callback',
		array( 'page', 'post' ),
		'normal',
		'high'
	);
}
add_action( 'add_meta_boxes', 'home_experts_add_sidebar_layout_box' );

function home_experts_sidebar_layout_callback( $post ) {
	$sidebar_layout = array(
		'default'       => array(
			'value'     => 'default',
			'label'     => __( 'Default Sidebar', 'home-experts' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/default.png',
		),
		'full-width'    => array(
			'value'     => 'full-width',
			'label'     => __( 'Full Sidebar', 'home-experts' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/full-width.jpg',
		),
		'left-sidebar'  => array(
			'value'     => 'left-sidebar',
			'label'     => __( 'Left Sidebar', 'home-experts' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/left.jpg',
		),
		'right-sidebar' => array(
			'value'     => 'right-sidebar',
			'label'     => __( 'Right Sidebar', 'home-experts' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/right.jpg',
		),
	);
	// Output the nonce field
	wp_nonce_field( 'home_experts_sidebar_nonce', 'home_experts_sidebar_nonce' );
	
	// Get the saved value once, outside the loop
	$value = get_post_meta( $post->ID, 'home_experts_sidebar_layout', true );
	if ( empty( $value ) ) {
		$value = 'right-sidebar';
	}
	?>     
	<div>
		<h4>
			<?php esc_html_e( 'Choose Sidebar Template', 'home-experts' ); ?>
		</h4>

		<div class="sidebar-layout" >
			<?php
			foreach ( $sidebar_layout as $layout ) {
				?>
					<div class="sidebar-option">
						<input 
							id="<?php echo esc_attr( $layout['value'] ); ?>" 
							type="radio" 
							name="he_sidebar_layout" 
							value="<?php echo esc_attr( $layout['value'] ); ?>" 
							<?php checked( $layout['value'], $value ); ?>
						/>
						<label class="description" for="<?php echo esc_attr( $layout['value'] ); ?>">
							<img src="<?php echo esc_url( $layout['thumbnail'] ); ?>" />                               
						</label>
					</div>
				<?php
			}
			?>
		</div>
	</div>
	<?php
}


function home_experts_save_sidebar_layout( $post_id ) {
	// Verify the nonce before proceeding.
	if ( ! isset( $_POST['home_experts_sidebar_nonce'] ) || ! wp_verify_nonce( $_POST['home_experts_sidebar_nonce'], 'home_experts_sidebar_nonce' ) ) {
		return;
	}

	// Check if the user has permission to edit the post
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}

	// Check if this is an autosave
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	// Save the meta value
	if ( isset( $_POST['he_sidebar_layout'] ) ) {
		$selected_layout = sanitize_key( $_POST['he_sidebar_layout'] );

		$valid_layouts = array(
			'default',
			'full-width',
			'left-sidebar',
			'right-sidebar',
		);

		if ( in_array( $selected_layout, $valid_layouts, true ) ) {
			update_post_meta( $post_id, 'home_experts_sidebar_layout', $selected_layout );
		} else {
			// If the selected layout is not valid, default to 'right-sidebar'
			update_post_meta( $post_id, 'home_experts_sidebar_layout', 'right-sidebar' );
		}
	}
}
add_action( 'save_post', 'home_experts_save_sidebar_layout' );