<?php

if ( ! function_exists( 'home_experts_customize_register_typography_body' ) ) :
	/**
	 * Typography Body Settings
	 *
	 * @package Home Experts
	 */
	function home_experts_customize_register_typography_body( $wp_customize ) {
		$wp_customize->add_section(
			'typography_settings',
			array(
				'title'    => __( 'Typography Settings', 'home-experts' ),
				'priority' => 50,
				'panel'    => 'appearance_settings',
			)
		);

		$wp_customize->add_setting(
			'toggle_localgoogle_fonts',
			array(
				'default'           => false,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'toggle_localgoogle_fonts',
				array(
					'label'   => __( 'Enable to load the google fonts locally.', 'home-experts' ),
					'section' => 'typography_settings',
					'type'    => 'checkbox',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_typography_body' );
