<?php
/**
 * Home Experts Theme Information Link Section
 *
 * @package Home Experts
 */

if ( ! function_exists( 'home_experts_theme_info' ) ) :
	/**
	 * Add theme information and pro upgrade sections to customizer.
	 *
	 * @since 1.0.0
	 * @param WP_Customize_Manager $customizer_manager The customizer manager object.
	 * @return void
	 */
	function home_experts_theme_info( $customizer_manager ) {
		// Add theme info section
		$customizer_manager->add_section(
			'theme_info',
			array(
				'title'    => esc_html__( 'Information Links', 'home-experts' ),
				'priority' => 6,
			)
		);

		/** Important Links */
		$customizer_manager->add_setting(
			'theme_info_theme',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$theme_info  = '<ul>';
		$theme_info .= sprintf( __( '<li>View documentation: %1$sClick here.%2$s</li>', 'home-experts' ), '<a href="' . esc_url( 'https://glthemes.com/documentation/home-experts/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>Theme info: %1$sClick here.%2$s</li>', 'home-experts' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/home-experts/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>Support ticket: %1$sClick here.%2$s</li>', 'home-experts' ), '<a href="' . esc_url( 'https://glthemes.com/support/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>More WordPress Themes: %1$sClick here.%2$s</li>', 'home-experts' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= '</ul>';

		$customizer_manager->add_control(
			new Home_Experts_Note_Control(
				$customizer_manager,
				'theme_info_theme',
				array(
					'label'       => esc_html__( 'Important Links', 'home-experts' ),
					'section'     => 'theme_info',
					'description' => $theme_info,
				)
			)
		);

		// Add pro upgrade section using the proper View Pro control
		$customizer_manager->add_section(
			new Home_Experts_View_Pro_Control(
				$customizer_manager,
				'home_experts_view_pro',
				array(
					'title'    => esc_html__( 'Pro Available', 'home-experts' ),
					'priority' => 5,
					'pro_text' => esc_html__( 'VIEW PRO THEME', 'home-experts' ),
					'pro_url'  => 'https://glthemes.com/wordpress-theme/home-experts-pro/',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_theme_info', 9999 );
