<?php

if ( ! function_exists( 'home_experts_customize_register_post_archive' ) ) :
	/**
	 * Servive single post and archive
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_post_archive( $wp_customize ) {
		$wp_customize->add_section(
			'post_archive',
			array(
				'title'    => __( 'Blog, Search and Archive Settings', 'home-experts' ),
				'panel'    => 'general_settings_panel',
				'priority' => 30,
			)
		);

		$wp_customize->add_setting(
			'mp_archive_prefix',
			array(
				'default'           => true,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'mp_archive_prefix',
				array(
					'label'       => __( 'Show/Hide Prefix', 'home-experts' ),
					'description' => __( 'Enable to hide prefix in archive page.', 'home-experts' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Archive Posted Date */
		$wp_customize->add_setting(
			'ed_archive_posted_date',
			array(
				'default'           => true,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'ed_archive_posted_date',
			array(
				'selector'        => '.blog__posted-on',
				'render_callback' => function () {
					return get_theme_mod( 'ed_archive_posted_date', true );
				},
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'ed_archive_posted_date',
				array(
					'label'       => __( 'Show/Hide Posted Date', 'home-experts' ),
					'description' => __( 'Enable to show posted date or disable to hide posted date', 'home-experts' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Archive Posted Date */
		$wp_customize->add_setting(
			'ed_archive_post_category',
			array(
				'default'           => true,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'ed_archive_post_category',
			array(
				'selector'        => '.blog__info',
				'render_callback' => function () {
					return get_theme_mod( 'ed_archive_post_category', true );
				},
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'ed_archive_post_category',
				array(
					'label'       => __( 'Show/Hide Post Category', 'home-experts' ),
					'description' => __( 'Enable to show post category or disable to hide post category', 'home-experts' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Line break for post and page settings */
		$wp_customize->add_setting(
			'search_page_note',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Note_Control(
				$wp_customize,
				'search_page_note',
				array(
					'section' => 'post_archive',
				)
			)
		);

		$wp_customize->add_setting(
			'post_archive_search_notice',
			array(
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new GL_Notice_Control(
				$wp_customize,
				'post_archive_search_notice',
				array(
					'label'   => __( 'Search Page Settings', 'home-experts' ),
					'section' => 'post_archive',
				)
			)
		);

		// Toggle to enable/disable entire search block
		$wp_customize->add_setting(
			'ed_search_block',
			array(
				'default'           => true,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'ed_search_block',
				array(
					'label'       => __( 'Show/Hide Search block', 'home-experts' ),
					'description' => __( 'Enable to show post search form or disable to hide search form', 'home-experts' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_post_archive' );
