<?php

if ( ! function_exists( 'home_experts_customize_register_pagination_settings' ) ) :
	/**
	 * Pagination Settings
	 *
	 * @package Home Experts
	 */
	function home_experts_customize_register_pagination_settings( $wp_customize ) {
		/** Pagination Settings */
		$wp_customize->add_section(
			'pagination_settings',
			array(
				'title'    => __( 'Pagination Settings', 'home-experts' ),
				'panel'    => 'general_settings_panel',
				'priority' => 80,
			)
		);

		/** Pagination Type */
		$wp_customize->add_setting(
			'pagination_type',
			array(
				'default'           => 'default',
				'sanitize_callback' => 'home_experts_radio_sanitization_header',
			)
		);

		$wp_customize->add_control(
			'pagination_type',
			array(
				'type'        => 'radio',
				'section'     => 'pagination_settings',
				'label'       => __( 'Pagination Type', 'home-experts' ),
				'description' => __( 'Select pagination of your choice.', 'home-experts' ),
				'choices'     => array(
					'default'  => __( 'Default (Older / Newer)', 'home-experts' ),
					'numbered' => __( 'Numbered (1 2 3 4...)', 'home-experts' )
				),
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_pagination_settings' );
