<?php

if ( ! function_exists( 'home_experts_customize_register_layout_settings' ) ) :
	/**
	 * Layout Settings
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_layout_settings( $wp_customize ) {
		$wp_customize->add_section(
			'layout_settings',
			array(
				'title'    => __( 'Layout Settings', 'home-experts' ),
				'priority' => 60,
				'panel'    => 'general_settings_panel',
			)
		);

		$wp_customize->add_setting(
			'single_page_layouts',
			array(
				'default'           => 'gl-right-wrap',
				'sanitize_callback' => 'home_experts_radio_sanitization_header',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Radio_Image_Control(
				$wp_customize,
				'single_page_layouts',
				array(
					'label'   => __( 'Page Layouts', 'home-experts' ),
					'row'     => '2',
					'section' => 'layout_settings',
					'choices' => array(
						'gl-full-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/full-width.jpg',
							'name'  => __( 'Full Width', 'home-experts' ),
						),
						'gl-right-wrap' => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/right.jpg',
							'name'  => __( 'Right Sidebar', 'home-experts' ),
						),
						'gl-left-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/left.jpg',
							'name'  => __( 'Left Sidebar', 'home-experts' ),
						),
					),
				)
			)
		);

		$wp_customize->add_setting(
			'single_post_layouts',
			array(
				'default'           => 'gl-right-wrap',
				'sanitize_callback' => 'home_experts_radio_sanitization_header',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Radio_Image_Control(
				$wp_customize,
				'single_post_layouts',
				array(
					'label'   => __( 'Post Layouts', 'home-experts' ),
					'row'     => '2',
					'section' => 'layout_settings',
					'choices' => array(
						'gl-full-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/full-width.jpg',
							'name'  => __( 'Full Width', 'home-experts' ),
						),
						'gl-right-wrap' => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/right.jpg',
							'name'  => __( 'Right Sidebar', 'home-experts' ),
						),
						'gl-left-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/left.jpg',
							'name'  => __( 'Left Sidebar', 'home-experts' ),
						),
					),
				)
			)
		);

		$wp_customize->add_setting(
			'archive_page_layouts',
			array(
				'default'           => 'gl-right-wrap',
				'sanitize_callback' => 'home_experts_radio_sanitization_header',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Radio_Image_Control(
				$wp_customize,
				'archive_page_layouts',
				array(
					'label'   => __( 'Archive', 'home-experts' ),
					'row'     => '2',
					'section' => 'layout_settings',
					'choices' => array(
						'gl-full-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/full-width.jpg',
							'name'  => __( 'Full Width', 'home-experts' ),
						),
						'gl-right-wrap' => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/right.jpg',
							'name'  => __( 'Right Sidebar', 'home-experts' ),
						),
						'gl-left-wrap'  => array(
							'image' => trailingslashit( get_template_directory_uri() ) . 'assets/images/sidebar/left.jpg',
							'name'  => __( 'Left Sidebar', 'home-experts' ),
						),
					),
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_layout_settings' );
