<?php
/**
 * Social Media
 * 
 * @package Home Experts
 */

if ( ! function_exists( 'home_experts_customize_register_socialmedia' ) ) :
	/**
	 * Headers Socialmedia
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_socialmedia( $wp_customize ) {
		// Create a new section top bar settings----------
		$wp_customize->add_section(
			'social_media_section',
			array(
				'title'    => __( 'Social Media Settings', 'home-experts' ),
				'priority' => 20,
				'panel'    => 'general_settings_panel',
			)
		);

		// Add the toggle control to the section
		$wp_customize->add_setting(
			'socialmedia_toggle',
			array(
				'default'           => false,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'socialmedia_toggle',
				array(
					'label'       => __( 'Show/Hide Social Media', 'home-experts' ),
					'description' => __( 'Enable to show the social media.', 'home-experts' ),
					'section'     => 'social_media_section',
					'type'        => 'checkbox',
				)
			)
		);

		$wp_customize->add_setting(
			'socialmedia_heading',
			array(
				'default'           => __( 'Follow Us:', 'home-experts' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		// Facebook Link
		$wp_customize->add_setting(
			'social_facebook_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_facebook_link',
			array(
				'label'           => esc_html__( 'Facebook Link', 'home-experts' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'home_experts_social_media_active_callback',
			)
		);

		// Instagram Link
		$wp_customize->add_setting(
			'social_instagram_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_instagram_link',
			array(
				'label'           => esc_html__( 'Instagram Link', 'home-experts' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'home_experts_social_media_active_callback',
			)
		);

		// LinkedIn Link
		$wp_customize->add_setting(
			'social_linkedin_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_linkedin_link',
			array(
				'label'           => esc_html__( 'LinkedIn Link', 'home-experts' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'home_experts_social_media_active_callback',
			)
		);

		// Pinterest Link
		$wp_customize->add_setting(
			'social_pinterest_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_pinterest_link',
			array(
				'label'           => esc_html__( 'Pinterest Link', 'home-experts' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'home_experts_social_media_active_callback',
			)
		);

		// Open in new tab toggle
		$wp_customize->add_setting(
			'md_social_checkbox',
			array(
				'default'           => true,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'md_social_checkbox',
				array(
					'label'           => esc_html__( 'Enable to open in new tab.', 'home-experts' ),
					'section'         => 'social_media_section',
					'type'            => 'checkbox',
					'active_callback' => 'home_experts_social_media_active_callback',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_socialmedia' );

function home_experts_social_media_active_callback( $control ) {
	$toggle_social_media = $control->manager->get_setting( 'socialmedia_toggle' )->value();

	$id = $control->id;

	// Check if social media toggle is enabled
	if ( ! $toggle_social_media ) {
		return false;
	}

	// List of all social media related control IDs
	$social_media_controls = array(
		'socialmedia_heading',
		'social_facebook_link',
		'social_instagram_link',
		'social_linkedin_link',
		'social_pinterest_link',
		'md_social_checkbox',
	);

	// Return true if the current control is in our social media controls list
	return in_array( $id, $social_media_controls );
}
