<?php
if ( ! function_exists( 'home_experts_customize_register_frontopbar' ) ) :
	/**
	 * Headers
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_frontopbar( $wp_customize ) {
		$wp_customize->add_section(
			'top_bar_section',
			array(
				'title'    => esc_html__( 'Header Settings', 'home-experts' ),
				'priority' => 20,
				'panel'    => 'general_settings_panel',
			)
		);

		// Add the toggle control to the section
		$wp_customize->add_setting(
			'topbar_toggle',
			array(
				'default'           => false,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'topbar_toggle',
				array(
					'label'       => esc_html__( 'Show/Hide Header', 'home-experts' ),
					'description' => esc_html__( 'Enable to show the header.', 'home-experts' ),
					'section'     => 'top_bar_section',
					'type'        => 'checkbox',
				)
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'topbar_toggle',
			array(
				'selector'        => '.site-header',
				'render_callback' => 'home_experts_header_inclusion',
			)
		);
		

		$wp_customize->add_setting(
			'header_btn_text',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'header_btn_text',
			array(
				'selector'        => '.header-link-list a.btn.btn-secondary',
				'render_callback' => function () {
						return esc_html( get_theme_mod( 'header_btn_text') );
				},
			)
		);

		// add control for get started title
		$wp_customize->add_control(
			'header_btn_text',
			array(
				'label'           => __( 'Button Text', 'home-experts' ),
				'section'         => 'top_bar_section',
				'type'            => 'text',
				'active_callback' => 'home_experts_fronttopbar_active_callback',
			)
		);
		// adding setting for get started link
		$wp_customize->add_setting(
			'header_btn_link',
			array(
				'default'           => '',
				'sanitize_callback' => 'esc_url_raw',
			)
		);
		// add control for get started link
		$wp_customize->add_control(
			'header_btn_link',
			array(
				'label'           => __( 'Button Link', 'home-experts' ),
				'section'         => 'top_bar_section',
				'type'            => 'url',
				'active_callback' => 'home_experts_fronttopbar_active_callback',
			)
		);

		// add setting and control for email-----> header 4
		$wp_customize->add_setting(
			'email',
			array(
				'default'           => sanitize_email( 'dolores@example.com' ),
				'sanitize_callback' => 'sanitize_email',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'email',
			array(
				'selector'        => '.header-email',
				'render_callback' => function () {
						return esc_html( get_theme_mod( 'email', sanitize_email( 'dolores@example.com' ) ) );
				},
			)
		);

		$wp_customize->add_control(
			'email',
			array(
				'label'           => __( 'E-mail:', 'home-experts' ),
				'section'         => 'top_bar_section',
				'type'            => 'email',
				'active_callback' => 'home_experts_fronttopbar_active_callback',
			)
		);

		// add setting and control for location
		$wp_customize->add_setting(
			'location',
			array(
				'default'           => __( '3517 W., Pennsylvania 57867', 'home-experts' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'location',
			array(
				'selector'        => '.header-location',
				'render_callback' => function () {
						return esc_html( get_theme_mod( 'location', __( '3517 W., Pennsylvania 57867', 'home-experts' ) ) );
				},
			)
		);

		$wp_customize->add_control(
			'location',
			array(
				'label'           => __( 'Location', 'home-experts' ),
				'section'         => 'top_bar_section',
				'type'            => 'text',
				'active_callback' => 'home_experts_fronttopbar_active_callback',
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_frontopbar' );

if ( ! function_exists( 'home_experts_fronttopbar_active_callback' ) ) :
	function home_experts_fronttopbar_active_callback( $control ) {
		$topbar_toggle  = $control->manager->get_setting( 'topbar_toggle' )->value();

		// If topbar is disabled, hide other controls
		if ( ! $topbar_toggle ) {
			return false;
		}

		return true;

	}
endif;
