<?php

if ( ! function_exists( 'home_experts_customize_register_footer_contactform' ) ) :
	/**
	 * Footer Panel's Contactform Section
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_footer_contactform( $wp_customize ) {

		/** Contactform Section */
		$wp_customize->add_section(
			'footer_newsletter_section',
			array(
				'title'    => __( 'Newsletter Section', 'home-experts' ),
				'priority' => 10,
				'panel'    => 'footer_settings',
			)
		);

		// Add the toggle control to the section
		$wp_customize->add_setting(
			'toggle_footer_newsletter',
			array(
				'default'           => false,
				'sanitize_callback' => 'home_experts_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new Home_Experts_Toggle_Control(
				$wp_customize,
				'toggle_footer_newsletter',
				array(
					'label'       => __( 'Show/Hide Newsletter Section', 'home-experts' ),
					'description' => __( 'Enable to show newsletter section', 'home-experts' ),
					'section'     => 'footer_newsletter_section',
					'type'        => 'checkbox',
				)
			)
		);

		// Add setting for Footer subheading
		$wp_customize->add_setting(
			'footer_subheading',
			array(
				'default'           => __( 'Newsletter', 'home-experts' ),
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		// Add Control for Footer subheading
		$wp_customize->add_control(
			'footer_subheading',
			array(
				'label'           => __( 'Subheading', 'home-experts' ),
				'section'         => 'footer_newsletter_section',
				'type'            => 'text',
				'active_callback' => 'home_experts_footer_newsletter_active_callback',
			)
		);

		// Add setting for Footer Heading
		$wp_customize->add_setting(
			'footer_heading',
			array(
				'default'           => __( 'Subscribe Us & Get Weekly Notifications', 'home-experts' ),
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		// Add Control for Footer Heading
		$wp_customize->add_control(
			'footer_heading',
			array(
				'label'           => __( 'Heading', 'home-experts' ),
				'section'         => 'footer_newsletter_section',
				'type'            => 'text',
				'active_callback' => 'home_experts_footer_newsletter_active_callback',
			)
		);

		// Add setting for Footer contactform shortcode
		$wp_customize->add_setting(
			'footer_contactform_shortcode',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		// Add Control for Footer contactform shortcode
		$wp_customize->add_control(
			'footer_contactform_shortcode',
			array(
				'label'           => __( 'Enter Shortcode', 'home-experts' ),
				'section'         => 'footer_newsletter_section',
				'type'            => 'text',
				'active_callback' => 'home_experts_footer_newsletter_active_callback',
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_footer_contactform' );

function home_experts_footer_newsletter_active_callback( $control ) {

	$toggle_footer_newsletter = $control->manager->get_setting( 'toggle_footer_newsletter' )->value();

	$id = $control->id;

	if ( $id == 'footer_subheading' && $toggle_footer_newsletter ) {
		return true;
	}
	if ( $id == 'footer_heading' && $toggle_footer_newsletter ) {
		return true;
	}
	if ( $id == 'footer_contactform_shortcode' && $toggle_footer_newsletter ) {
		return true;
	}

	return false;
}
