<?php

if ( ! function_exists( 'home_experts_customize_register_panels' ) ) :
	/**
	 * Registering Panel
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function home_experts_customize_register_panels( $wp_customize ) {
		$wp_customize->add_panel(
			'appearance_settings',
			array(
				'title'    => esc_html__( 'Appearance Settings', 'home-experts' ),
				'priority' => 10,
			)
		);

		$wp_customize->add_panel(
			'frontpage_settings_panel',
			array(
				'title'       => esc_html__( 'Front Page Settings', 'home-experts' ),
				'description' => esc_html__( 'Static Home Page Settings.', 'home-experts' ),
				'priority'    => 10,
			)
		);

		$wp_customize->add_panel(
			'general_settings_panel',
			array(
				'title'       => esc_html__( 'General Settings', 'home-experts' ),
				'description' => esc_html__( 'General Desc', 'home-experts' ),
				'priority'    => 10,
			)
		);

		$wp_customize->add_panel(
			'header_settings_panel',
			array(
				'title'       => esc_html__( 'Header Settings', 'home-experts' ),
				'description' => esc_html__( 'Configure header layout and contact information.', 'home-experts' ),
				'priority'    => 15,
			)
		);        // ----------------------------Footer panel------------------------
		$wp_customize->add_panel(
			'footer_settings',
			array(
				'title'       => esc_html__( 'Footer Settings', 'home-experts' ),
				'description' => esc_html__( 'Footer Desc', 'home-experts' ),
				'priority'    => 10,
			)
		);
	}
endif;
add_action( 'customize_register', 'home_experts_customize_register_panels' );
