<?php
/**
 * Sanitization Functions
 *
 * @package Home Experts
 */

if ( ! function_exists( 'home_experts_sanitize_checkbox' ) ) :
	/**
	 * Sanitize Checkbox
	 */
	function home_experts_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}
endif;

if ( ! function_exists( 'home_experts_sanitize_hex_color' ) ) {
	/**
	 * Function for sanitizing Hex color
	 */
	function home_experts_sanitize_hex_color( $color ) {
		if ( '' === $color ) {
			return '';
		}

		// 3 or 6 hex digits, or the empty string.
		if ( preg_match( '|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
			return $color;
		}
	}
}

if ( ! function_exists( 'home_experts_radio_sanitization_header' ) ) {
	/**
	 * Function for Sanitization Header
	 */
	function home_experts_radio_sanitization_header( $input, $setting ) {
		// get the list of possible radio box or select options
		$choices = $setting->manager->get_control( $setting->id )->choices;
		if ( array_key_exists( $input, $choices ) ) {
			return $input;
		} else {
			return $setting->default;
		}
	}
}
